/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerFilter;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.IProducerRegistryAPI;
import net.anotheria.moskito.core.registry.IProducerRegistryListener;
import net.anotheria.moskito.core.registry.IntervalInfo;
import net.anotheria.moskito.core.registry.NoSuchProducerException;
import net.anotheria.moskito.core.registry.ProducerReference;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.registry.filters.CategoryFilter;
import net.anotheria.moskito.core.registry.filters.SubsystemFilter;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.IntervalRegistryListener;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerRegistryAPIImpl
implements IProducerRegistryAPI,
IProducerRegistryListener,
IntervalRegistryListener,
IIntervalListener {
    private static final Logger log = LoggerFactory.getLogger(ProducerRegistryAPIImpl.class);
    private List<ProducerReference> _cachedProducerList = null;
    private Map<String, ProducerReference> _cachedProducerMap = null;
    private List<IntervalInfo> _cachedIntervalInfos = null;
    private IProducerRegistry registry = ProducerRegistryFactory.getProducerRegistryInstance();
    private IntervalRegistry intervalRegistry;
    private static final Object cacheLock = new Object();
    private static final Object intervalLock = new Object();

    ProducerRegistryAPIImpl() {
        this.registry.addListener(this);
        this.intervalRegistry = IntervalRegistry.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProducerCacheFromScratch() {
        log.debug("rebuilding producer cache");
        Object object = cacheLock;
        synchronized (object) {
            if (this._cachedProducerList != null) {
                return;
            }
            this.rebuildProducerCache(this.registry.getProducers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildProducerCache(Collection<IStatsProducer> producers) {
        log.debug("Rebuilding producer cache with " + producers.size() + " producers.");
        log.debug("Following producers known: " + producers);
        Object object = cacheLock;
        synchronized (object) {
            int approxSize = (int)((double)producers.size() * 1.5);
            this._cachedProducerList = new ArrayList<ProducerReference>(approxSize);
            this._cachedProducerMap = new HashMap<String, ProducerReference>(approxSize);
            for (IStatsProducer sp : producers) {
                ProducerReference reference = new ProducerReference(sp);
                this._cachedProducerList.add(reference);
                this._cachedProducerMap.put(sp.getProducerId(), reference);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Cachedproducer list contains " + this._cachedProducerList.size() + " producers: ");
            log.debug("" + this._cachedProducerList);
            log.debug("Cached producer map contains: " + this._cachedProducerMap.size() + " producers");
            log.debug("" + this._cachedProducerMap);
        }
    }

    @Override
    public List<IStatsProducer> getAllProducers() {
        if (this._cachedProducerList == null) {
            this.buildProducerCacheFromScratch();
        }
        ArrayList<IStatsProducer> ret = new ArrayList<IStatsProducer>();
        for (ProducerReference pr : this._cachedProducerList) {
            if (pr.get() == null) continue;
            ret.add(pr.get());
        }
        return ret;
    }

    @Override
    public List<IStatsProducer> getAllProducersByCategory(String category) {
        return this.getProducers(new CategoryFilter(category));
    }

    @Override
    public List<IStatsProducer> getAllProducersBySubsystem(String subsystem) {
        return this.getProducers(new SubsystemFilter(subsystem));
    }

    @Override
    public List<IntervalInfo> getPresentIntervals() {
        if (this._cachedIntervalInfos == null) {
            this.createIntervalList();
        }
        return this._cachedIntervalInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIntervalList() {
        Object object = intervalLock;
        synchronized (object) {
            if (this._cachedIntervalInfos != null) {
                return;
            }
            List<Interval> intervals = this.intervalRegistry.getIntervals();
            this._cachedIntervalInfos = new ArrayList<IntervalInfo>(intervals.size());
            for (Interval interval : intervals) {
                this._cachedIntervalInfos.add(new IntervalInfo(interval));
                interval.addSecondaryIntervalListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalUpdated(Interval aCaller) {
        IntervalInfo dummy = new IntervalInfo(aCaller);
        Object object = intervalLock;
        synchronized (object) {
            int index = this._cachedIntervalInfos.indexOf(dummy);
            if (index == -1) {
                return;
            }
            this._cachedIntervalInfos.get(index).update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalCreated(Interval aInterval) {
        Object object = intervalLock;
        synchronized (object) {
            this._cachedIntervalInfos.add(new IntervalInfo(aInterval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatsProducer getProducer(String producerId) {
        if (this._cachedProducerList == null) {
            this.buildProducerCacheFromScratch();
        }
        Object object = cacheLock;
        synchronized (object) {
            ProducerReference ref = this._cachedProducerMap.get(producerId);
            if (ref == null) {
                throw new NoSuchProducerException(producerId);
            }
            return ref.get();
        }
    }

    @Override
    public List<IStatsProducer> getProducers(IProducerFilter ... filters) {
        if (this._cachedProducerList == null) {
            this.buildProducerCacheFromScratch();
        }
        ArrayList<IStatsProducer> ret = new ArrayList<IStatsProducer>();
        List workCopy = (List)((ArrayList)this._cachedProducerList).clone();
        for (ProducerReference p : workCopy) {
            IStatsProducer pp = p.get();
            boolean fit = true;
            if (pp == null) continue;
            for (IProducerFilter filter : filters) {
                if (filter.doesFit(pp)) continue;
                fit = false;
                break;
            }
            if (!fit) continue;
            ret.add(pp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProducerRegistered(IStatsProducer producer) {
        log.info("Producer registered: " + producer.getProducerId() + " / " + producer);
        if (this._cachedProducerList == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ProducerReference pr = new ProducerReference(producer);
            this._cachedProducerList.add(pr);
            this._cachedProducerMap.put(producer.getProducerId(), pr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProducerUnregistered(IStatsProducer producer) {
        log.info("Producer unregistered: " + producer.getProducerId() + " / " + producer);
        if (this._cachedProducerList == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ProducerReference ref = this._cachedProducerMap.remove(producer.getProducerId());
            if (ref != null) {
                this._cachedProducerList.remove(ref);
            }
        }
    }

    @Override
    public List<String> getCategories() {
        ArrayList<String> ret = new ArrayList<String>();
        List<IStatsProducer> producers = this.getAllProducers();
        for (IStatsProducer p : producers) {
            if (ret.contains(p.getCategory())) continue;
            ret.add(p.getCategory());
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public List<String> getSubsystems() {
        ArrayList<String> ret = new ArrayList<String>();
        List<IStatsProducer> producers = this.getAllProducers();
        for (IStatsProducer p : producers) {
            if (ret.contains(p.getSubsystem())) continue;
            ret.add(p.getSubsystem());
        }
        Collections.sort(ret);
        return ret;
    }
}

