/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.moskito.core.stats.UnknownIntervalLengthException;

class IntervalNameParser {
    private static Map<Character, TimeUnit> lookupMap = new HashMap<Character, TimeUnit>();

    IntervalNameParser() {
    }

    static final int guessLengthFromName(String aName) {
        int value;
        if (aName.startsWith("snapshot")) {
            return -1;
        }
        try {
            value = Integer.parseInt(aName.substring(0, aName.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new UnknownIntervalLengthException("Unsupported Interval name format: " + aName);
        }
        char lastChar = aName.charAt(aName.length() - 1);
        TimeUnit unit = lookupMap.get(Character.valueOf(Character.toLowerCase(lastChar)));
        if (unit == null) {
            throw new UnknownIntervalLengthException(aName + ", " + lastChar + " is not a supported unit.");
        }
        int unitFactor = unit.getFactor();
        if (value == 0) {
            throw new UnknownIntervalLengthException(aName + ", zero duration is not allowed.");
        }
        return value * unitFactor;
    }

    static {
        for (TimeUnit u : TimeUnit.values()) {
            lookupMap.put(Character.valueOf(u.getCaption()), u);
        }
    }

    private static enum TimeUnit {
        SECOND(1, 's'),
        MINUTE(60, 'm'),
        HOUR(MINUTE.getFactor() * 60, 'h'),
        DAY(HOUR.getFactor() * 24, 'd');

        private int factor;
        private final char caption;

        private TimeUnit(int aFactor, char aCaption) {
            this.factor = aFactor;
            this.caption = aCaption;
        }

        int getFactor() {
            return this.factor;
        }

        char getCaption() {
            return this.caption;
        }
    }
}

