/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.thresholds.GuardConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdsConfig;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.helper.RuntimeConstants;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.helper.TieableRepository;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.threshold.ExtendedThresholdStatus;
import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdDefinition;
import net.anotheria.moskito.core.threshold.ThresholdInStatus;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.guard.DoubleBarrierPassGuard;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;
import net.anotheria.moskito.core.threshold.guard.LongBarrierPassGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdRepository
extends TieableRepository<Threshold> {
    private static Logger log = LoggerFactory.getLogger(ThresholdRepository.class);
    private static ThresholdRepository INSTANCE = new ThresholdRepository();

    private ThresholdRepository() {
        this.readConfig();
    }

    public static ThresholdRepository getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean tie(Threshold threshold, IStatsProducer<? extends IStats> producer) {
        ThresholdDefinition definition = (ThresholdDefinition)threshold.getDefinition();
        IStats target = null;
        for (IStats iStats : producer.getStats()) {
            if (!iStats.getName().equals(definition.getStatName())) continue;
            target = iStats;
            break;
        }
        if (target == null) {
            if (producer instanceof OnDemandStatsProducer) {
                this.addToAutoTie(threshold, producer);
            } else {
                throw new IllegalArgumentException("StatObject not found " + definition.getStatName() + " in " + definition);
            }
        }
        threshold.tieToStats(target);
        return true;
    }

    @Override
    public void cleanup() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        List<Threshold> th = this.getThresholds();
        for (Threshold t : th) {
            String tName = ((ThresholdDefinition)t.getDefinition()).getName();
            try {
                this.unregisterMBean(mbs, this.createName(tName));
            }
            catch (MalformedObjectNameException e) {
                log.warn("can't unregister " + tName + ", ignored.", (Throwable)e);
            }
        }
        super.cleanup();
    }

    private ObjectName createName(String name) throws MalformedObjectNameException {
        String appName = RuntimeConstants.getApplicationName();
        String objectName = "moskito." + (appName.length() > 0 ? appName + "." : "") + "thresholds:type=" + name;
        ObjectName objName = new ObjectName(objectName);
        return objName;
    }

    private boolean unregisterMBean(MBeanServer mbs, ObjectName mbeanName) {
        if (mbs.isRegistered(mbeanName)) {
            try {
                mbs.unregisterMBean(mbeanName);
                return true;
            }
            catch (MBeanRegistrationException e) {
                log.warn("unable to unregister " + mbeanName + ", ignored.", (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                log.warn("unable to  unregister " + mbeanName + ", ignored.", (Throwable)e);
            }
        }
        return false;
    }

    public Threshold createThreshold(ThresholdDefinition definition) {
        Threshold ret = (Threshold)this.createTieable(definition);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = this.createName(((ThresholdDefinition)ret.getDefinition()).getName());
            if (this.unregisterMBean(mbs, name)) {
                log.info("there was already a MBean with name '" + name + "' registered. will be replaced now.");
            }
            mbs.registerMBean(ret, name);
        }
        catch (MalformedObjectNameException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (AccessControlException e) {
            log.warn("can't create jmx bean due to access control problems", (Throwable)e);
        }
        return ret;
    }

    public ExtendedThresholdStatus getExtendedWorstStatus(List<String> includedNames) {
        ThresholdStatus status = includedNames == null || includedNames.size() == 0 ? this.getWorstStatus() : this.getWorstStatus(includedNames);
        ExtendedThresholdStatus ret = new ExtendedThresholdStatus(status);
        for (Threshold t : this.getThresholds()) {
            if (t.getStatus() != status || includedNames != null && includedNames.indexOf(t.getName()) == -1) continue;
            ThresholdInStatus tis = new ThresholdInStatus();
            tis.setThresholdName(t.getName());
            tis.setValue(t.getLastValue());
            ret.add(tis);
        }
        return ret;
    }

    public ExtendedThresholdStatus getExtendedWorstStatusWithout(List<String> excludedNames) {
        ThresholdStatus status = this.getWorstStatusWithout(excludedNames);
        ExtendedThresholdStatus ret = new ExtendedThresholdStatus(status);
        for (Threshold t : this.getThresholds()) {
            if (t.getStatus() != status || excludedNames != null && excludedNames.indexOf(t.getName()) != -1) continue;
            ThresholdInStatus tis = new ThresholdInStatus();
            tis.setThresholdName(t.getName());
            tis.setValue(t.getLastValue());
            ret.add(tis);
        }
        return ret;
    }

    public ThresholdStatus getWorstStatus() {
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (!t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public ThresholdStatus getWorstStatus(String[] names) {
        return this.getWorstStatus(Arrays.asList(names));
    }

    public ThresholdStatus getWorstStatus(List<String> names) {
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (names.indexOf(t.getName()) == -1 || !t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public ThresholdStatus getWorstStatusWithout(List<String> names) {
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (names.indexOf(t.getName()) != -1 || !t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public List<Threshold> getThresholds() {
        return this.getTieables();
    }

    @Override
    protected Threshold create(TieableDefinition def) {
        return new Threshold((ThresholdDefinition)def);
    }

    private void readConfig() {
        ThresholdsConfig config = MoskitoConfigurationHolder.getConfiguration().getThresholdsConfig();
        ThresholdConfig[] tcs = config.getThresholds();
        if (tcs != null && tcs.length > 0) {
            for (ThresholdConfig tc : tcs) {
                ThresholdDefinition td = new ThresholdDefinition();
                td.setName(tc.getName());
                td.setIntervalName(tc.getIntervalName());
                td.setProducerName(tc.getProducerName());
                td.setStatName(tc.getStatName());
                td.setTimeUnit(TimeUnit.valueOf(tc.getTimeUnit()));
                td.setValueName(tc.getValueName());
                Threshold newThreshold = this.createThreshold(td);
                GuardConfig[] guards = tc.getGuards();
                if (guards == null || guards.length <= 0) continue;
                boolean hasDots = false;
                for (GuardConfig guard : guards) {
                    hasDots |= this.hasDots(guard.getValue());
                }
                for (GuardConfig guard : guards) {
                    newThreshold.addGuard(hasDots ? new DoubleBarrierPassGuard(ThresholdStatus.valueOf(guard.getStatus()), Double.parseDouble(guard.getValue()), GuardedDirection.valueOf(guard.getDirection())) : new LongBarrierPassGuard(ThresholdStatus.valueOf(guard.getStatus()), Long.parseLong(guard.getValue()), GuardedDirection.valueOf(guard.getDirection())));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This method is only for unit tests.")
    void reset() {
        this.cleanup();
        INSTANCE = new ThresholdRepository();
    }

    private boolean hasDots(String ... params) {
        if (params == null) {
            return false;
        }
        for (String p : params) {
            if (p == null || p.indexOf(46) <= 0) continue;
            return true;
        }
        return false;
    }
}

