/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.tracer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.tracer.Trace;

public class Tracer {
    private String producerId;
    private boolean enabled;
    private List<Trace> traces;

    public Tracer(String aProducerId) {
        this.producerId = aProducerId;
        this.enabled = true;
        this.traces = new CopyOnWriteArrayList<Trace>();
    }

    public String getProducerId() {
        return this.producerId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getEntryCount() {
        return this.traces == null ? 0 : this.traces.size();
    }

    public void addTrace(Trace aTrace, int toleratedAmount, int maxAmount) {
        this.traces.add(aTrace);
        if (this.traces.size() <= toleratedAmount) {
            return;
        }
        List<Trace> oldTraces = this.traces;
        this.traces = new CopyOnWriteArrayList<Trace>();
        int offset = toleratedAmount - maxAmount;
        for (int i = 1; i <= maxAmount; ++i) {
            this.traces.add(oldTraces.get(i + offset));
        }
    }

    public List<Trace> getTraces() {
        return this.traces;
    }
}

