/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.tracer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.tracing.TracingConfiguration;
import net.anotheria.moskito.core.tracer.Trace;
import net.anotheria.moskito.core.tracer.Tracer;
import net.anotheria.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracerRepository {
    private static Logger log = LoggerFactory.getLogger(TracerRepository.class);
    private static Logger traceLog = LoggerFactory.getLogger((String)"MoSKitoTracer");
    private static TracerRepository INSTANCE = new TracerRepository();
    private ConcurrentMap<String, Tracer> tracers = new ConcurrentHashMap<String, Tracer>();

    private TracerRepository() {
    }

    public static TracerRepository getInstance() {
        return INSTANCE;
    }

    public boolean isTracingEnabledForProducer(String producerId) {
        if (!MoskitoConfigurationHolder.getConfiguration().getTracingConfig().isTracingEnabled()) {
            return false;
        }
        Tracer tracer = (Tracer)this.tracers.get(producerId);
        return tracer != null && tracer.isEnabled();
    }

    public void addTracedExecution(String producerId, String call, StackTraceElement[] stackTraceElements, long executionTime) {
        TracingConfiguration config = MoskitoConfigurationHolder.getConfiguration().getTracingConfig();
        if (!config.isTracingEnabled()) {
            return;
        }
        if (config.isInspectEnabled()) {
            Trace newTrace = new Trace();
            newTrace.setCall(call);
            newTrace.setDuration(executionTime);
            newTrace.setElements(stackTraceElements);
            Tracer myTracer = this.getTracer(producerId);
            if (myTracer == null) {
                log.warn("Got a new incoming trace, but not tracer! ProducerId: " + producerId + ", Call: " + call);
                return;
            }
            myTracer.addTrace(newTrace, config.getToleratedTracesAmount(), config.getMaxTraces());
        }
        if (config.isLoggingEnabled()) {
            traceLog.info(NumberUtils.makeISO8601TimestampString() + ", call: " + call + " duration: " + executionTime);
            for (StackTraceElement e : stackTraceElements) {
                traceLog.info("\t" + e.toString());
            }
        }
    }

    public void enableTracingForProducerId(String producerId) {
        Tracer newTracer = new Tracer(producerId);
        Tracer old = this.tracers.putIfAbsent(producerId, newTracer);
        if (old != null) {
            old.setEnabled(true);
        }
    }

    public void disableTrackingForProducerId(String producerId) {
        Tracer tracer = (Tracer)this.tracers.get(producerId);
        if (tracer != null) {
            tracer.setEnabled(false);
        }
    }

    public void removeTracer(String producerId) {
        this.tracers.remove(producerId);
    }

    public List<Tracer> getTracers() {
        return new ArrayList<Tracer>(this.tracers.values());
    }

    public Tracer getTracer(String producerId) {
        return (Tracer)this.tracers.get(producerId);
    }

    public List<Trace> getTraces(String producerId) {
        return this.getTracer(producerId).getTraces();
    }
}

