/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.MemoryPoolStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;

public class BuiltInMemoryPoolProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private String producerId;
    private MemoryPoolStats stats;
    private List<IStats> statsList;
    private MemoryPoolMXBean pool;

    public BuiltInMemoryPoolProducer(MemoryPoolMXBean aPool) {
        this.pool = aPool;
        this.producerId = "MemoryPool-" + this.pool.getName() + "-" + (this.pool.getType() == MemoryType.HEAP ? "Heap" : "NonHeap");
        this.statsList = new CopyOnWriteArrayList<IStats>();
        this.stats = new MemoryPoolStats(this.producerId);
        this.statsList.add(this.stats);
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInMemoryPoolProducer.this.readMemory();
            }
        });
    }

    @Override
    public String getCategory() {
        return "memory";
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getSubsystem() {
        return "builtin";
    }

    private void readMemory() {
        MemoryUsage usage = this.pool.getUsage();
        this.stats.setCommited(usage.getCommitted());
        this.stats.setUsed(usage.getUsed());
        this.stats.setInit(usage.getInit());
        this.stats.setMax(usage.getMax());
    }

    MemoryPoolStats getMemoryPoolStats() {
        return this.stats;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.pool.getName();
    }
}

