/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.MemoryType;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.VirtualMemoryPoolStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryPoolProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;

public class BuiltInMemoryPoolVirtualProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private String producerId;
    private VirtualMemoryPoolStats stats;
    private List<IStats> statsList;

    public BuiltInMemoryPoolVirtualProducer(MemoryType type, List<BuiltInMemoryPoolProducer> producers) {
        this.producerId = type.toString();
        this.statsList = new CopyOnWriteArrayList<IStats>();
        this.stats = new VirtualMemoryPoolStats(this.producerId);
        for (BuiltInMemoryPoolProducer producer : producers) {
            this.stats.addStats(producer.getMemoryPoolStats());
        }
        this.statsList.add(this.stats);
    }

    @Override
    public String getCategory() {
        return "memory";
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.statsList;
    }
}

