/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.ThreadStateStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;

public class BuiltInThreadStatesProducer
extends AbstractBuiltInProducer<ThreadStateStats>
implements IStatsProducer<ThreadStateStats>,
BuiltInProducer {
    private ThreadStateStats cumulated = new ThreadStateStats("cumulated");
    private List<ThreadStateStats> statsList;
    private Map<Thread.State, ThreadStateStats> statsMap = new HashMap<Thread.State, ThreadStateStats>();
    private ThreadMXBean threadMxBean;

    BuiltInThreadStatesProducer() {
        this.statsList = new CopyOnWriteArrayList<ThreadStateStats>();
        this.statsList.add(this.cumulated);
        for (Thread.State state : Thread.State.values()) {
            ThreadStateStats statsObject = new ThreadStateStats(state.name());
            this.statsMap.put(state, statsObject);
            this.statsList.add(statsObject);
        }
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        IProducerRegistry reg = ProducerRegistryFactory.getProducerRegistryInstance();
        reg.registerProducer(this);
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInThreadStatesProducer.this.readThreads();
            }
        });
    }

    private void readThreads() {
        long[] ids = this.threadMxBean.getAllThreadIds();
        HashMap<Thread.State, Long> count = new HashMap<Thread.State, Long>();
        for (int i = 0; i < ids.length; ++i) {
            long id = ids[i];
            ThreadInfo info = this.threadMxBean.getThreadInfo(id);
            if (info == null) continue;
            Thread.State state = info.getThreadState();
            Long old = (Long)count.get((Object)state);
            if (old == null) {
                old = 0L;
            }
            count.put(state, old + 1L);
        }
        long total = 0L;
        Iterator<Map.Entry<Thread.State, ThreadStateStats>> i$ = this.statsMap.entrySet().iterator();
        while (i$.hasNext()) {
            Long c;
            Map.Entry<Thread.State, ThreadStateStats> entry;
            entry.getValue().updateCurrentValue((c = (Long)count.get((Object)(entry = i$.next()).getKey())) == null ? 0L : c);
            if (c == null) continue;
            total += c.longValue();
        }
        this.cumulated.updateCurrentValue(total);
    }

    @Override
    public String getCategory() {
        return "threads";
    }

    @Override
    public String getProducerId() {
        return "ThreadStates";
    }

    @Override
    public List<ThreadStateStats> getStats() {
        return this.statsList;
    }
}

