/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class SessionCountStats
extends AbstractStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("Cur", "Min", "Max", "New", "Del"));
    private StatValue numberOfCurrentSessions;
    private StatValue minNumberOfSessions;
    private StatValue maxNumberOfSessions;
    private StatValue numberOfCreatedSessions;
    private StatValue numberOfDestroyedSessions;

    public SessionCountStats() {
        this("Sessions", Constants.getDefaultIntervals());
    }

    public SessionCountStats(String name, Interval[] intervals) {
        super(name);
        Integer pattern = 0;
        this.numberOfCurrentSessions = StatValueFactory.createStatValue(StatValueTypes.COUNTER, "numberOfSessions", intervals);
        this.minNumberOfSessions = StatValueFactory.createStatValue(pattern, "minNumberOfSessions", intervals);
        this.minNumberOfSessions.setDefaultValueAsInt(Integer.MAX_VALUE);
        this.minNumberOfSessions.reset();
        this.maxNumberOfSessions = StatValueFactory.createStatValue(pattern, "maxNumberOfSessions", intervals);
        this.maxNumberOfSessions.setDefaultValueAsInt(Integer.MIN_VALUE);
        this.maxNumberOfSessions.reset();
        this.numberOfCreatedSessions = StatValueFactory.createStatValue(pattern, "createdSessions", intervals);
        this.numberOfDestroyedSessions = StatValueFactory.createStatValue(pattern, "destroyedSessions", intervals);
        this.addStatValues(this.numberOfCreatedSessions, this.maxNumberOfSessions, this.minNumberOfSessions, this.numberOfCreatedSessions, this.numberOfDestroyedSessions);
    }

    public void notifySessionCreated() {
        this.numberOfCreatedSessions.increase();
        this.numberOfCurrentSessions.increase();
        this.maxNumberOfSessions.setValueIfGreaterThanCurrentAsInt(this.numberOfCurrentSessions.getValueAsInt());
    }

    public void notifySessionDestroyed() {
        this.numberOfDestroyedSessions.increase();
        this.numberOfCurrentSessions.decrease();
        this.minNumberOfSessions.setValueIfLesserThanCurrentAsInt(this.numberOfCurrentSessions.getValueAsInt());
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder("Sessions ");
        ret.append(" Cur: ").append(this.numberOfCurrentSessions.getValueAsInt(intervalName));
        ret.append(" Min: ").append(this.minNumberOfSessions.getValueAsInt(intervalName));
        ret.append(" Max: ").append(this.maxNumberOfSessions.getValueAsInt(intervalName));
        ret.append(" New: ").append(this.numberOfCreatedSessions.getValueAsInt(intervalName));
        ret.append(" Del: ").append(this.numberOfDestroyedSessions.getValueAsInt(intervalName));
        return ret.toString();
    }

    public int getCurrentSessionCount(String intervalName) {
        return this.numberOfCurrentSessions.getValueAsInt(intervalName);
    }

    public int getMinSessionCount(String intervalName) {
        return this.minNumberOfSessions.getValueAsInt(intervalName);
    }

    public int getMaxSessionCount(String intervalName) {
        return this.maxNumberOfSessions.getValueAsInt(intervalName);
    }

    public int getCreatedSessionCount(String intervalName) {
        return this.numberOfCreatedSessions.getValueAsInt(intervalName);
    }

    public int getDestroyedSessionCount(String intervalName) {
        return this.numberOfDestroyedSessions.getValueAsInt(intervalName);
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            return null;
        }
        if ((valueName = valueName.toLowerCase()).equals("cur") || valueName.equals("current")) {
            return "" + this.getCurrentSessionCount(intervalName);
        }
        if (valueName.equals("min")) {
            return "" + this.getMinSessionCount(intervalName);
        }
        if (valueName.equals("max")) {
            return "" + this.getMaxSessionCount(intervalName);
        }
        if (valueName.equals("new")) {
            return "" + this.getCreatedSessionCount(intervalName);
        }
        if (valueName.equals("del")) {
            return "" + this.getDestroyedSessionCount(intervalName);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public String toString() {
        return this.toStatsString();
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }
}

