/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import net.anotheria.moskito.core.accumulation.Accumulator;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.accumulators.AccumulatorConfig;
import net.anotheria.moskito.core.config.accumulators.AccumulatorsConfig;
import net.anotheria.moskito.core.helper.AutoTieAbleProducer;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.helper.TieableRepository;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.stats.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccumulatorRepository<S extends IStats>
extends TieableRepository<Accumulator, S> {
    private static Logger log = LoggerFactory.getLogger(AccumulatorRepository.class);
    private static AccumulatorRepository<? extends IStats> INSTANCE = new AccumulatorRepository();

    public static AccumulatorRepository<? extends IStats> getInstance() {
        return INSTANCE;
    }

    private AccumulatorRepository() {
        this.readConfig();
    }

    @Override
    protected boolean tie(Accumulator acc, IStatsProducer<? extends IStats> producer) {
        AccumulatorDefinition definition = (AccumulatorDefinition)acc.getDefinition();
        IStats target = null;
        for (IStats iStats : producer.getStats()) {
            if (!iStats.getName().equals(definition.getStatName())) continue;
            target = iStats;
            break;
        }
        if (target == null) {
            if (producer instanceof AutoTieAbleProducer) {
                this.addToAutoTie(acc, producer);
            } else {
                throw new IllegalArgumentException("StatObject not found " + definition.getStatName() + " in " + definition);
            }
        }
        acc.tieToStats(target);
        return true;
    }

    @Override
    protected Accumulator create(TieableDefinition def) {
        return new Accumulator((AccumulatorDefinition)def);
    }

    public List<Accumulator> getAccumulators() {
        return this.getTieables();
    }

    public Accumulator createAccumulator(TieableDefinition def) {
        return (Accumulator)this.createTieable(def);
    }

    private void readConfig() {
        AccumulatorsConfig config = MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig();
        AccumulatorConfig[] acs = config.getAccumulators();
        if (acs != null && acs.length > 0) {
            for (AccumulatorConfig ac : acs) {
                AccumulatorDefinition ad = new AccumulatorDefinition();
                ad.setName(ac.getName());
                ad.setIntervalName(ac.getIntervalName());
                ad.setProducerName(ac.getProducerName());
                ad.setStatName(ac.getStatName());
                ad.setTimeUnit(TimeUnit.valueOf(ac.getTimeUnit()));
                ad.setValueName(ac.getValueName());
                Accumulator acc = this.createAccumulator(ad);
                if (!log.isDebugEnabled()) continue;
                log.debug("Created accumulator " + acc);
            }
        }
    }

    @Override
    public void notifyProducerUnregistered(IStatsProducer<S> producer) {
        for (Accumulator acc : this.getTieables()) {
            if (!((AccumulatorDefinition)acc.getDefinition()).getProducerName().equals(producer.getProducerId())) continue;
            try {
                acc.tieToStats(null);
                this.addUntied(acc);
            }
            catch (Exception e) {
                log.error("notifyProducerUnregistered(" + producer + ')', (Throwable)e);
            }
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This method is for unit testing only.")
    void reset() {
        this.cleanup();
        INSTANCE = new AccumulatorRepository<S>();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This method is for unit testing only.")
    public static void resetForUnitTests() {
        AccumulatorRepository.getInstance().reset();
    }
}

