/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.moskito.core.accumulation.Accumulator;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.accumulators.AccumulatorSetConfig;
import net.anotheria.moskito.core.config.accumulators.AccumulatorSetMode;
import net.anotheria.moskito.core.stats.TimeUnit;

public final class Accumulators {
    public static final String DEFAULT_INTERVAL = "5m";

    private Accumulators() {
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName, TimeUnit timeUnit) {
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(name);
        definition.setProducerName(producerName);
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(intervalName);
        Accumulator acc = AccumulatorRepository.getInstance().createAccumulator(definition);
        return acc;
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName) {
        return Accumulators.createAccumulator(name, producerName, statName, valueName, intervalName, TimeUnit.MILLISECONDS);
    }

    public static void createServiceAVGAccumulator(String name, String producerName) {
        Accumulators.createServiceAVGAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceAVGAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "AVG", interval);
    }

    public static void createServiceREQAccumulator(String name, String producerName) {
        Accumulators.createServiceREQAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceREQAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "REQ", interval);
    }

    public static void createUrlAVGAccumulator(String name, String url) {
        Accumulators.createUrlAVGAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlAVGAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "AVG", interval);
    }

    public static void createUrlREQAccumulator(String name, String url) {
        Accumulators.createUrlREQAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlREQAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "REQ", interval);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url) {
        Accumulators.createUrlTotalTimeAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "time", interval);
    }

    public static void createMemoryPoolAccumulator(String poolName, String producerName) {
        String[] intervals = new String[]{"1m", DEFAULT_INTERVAL, "1h"};
        String[] valuesNames = new String[]{"Free", "Free MB", "Used", "Used MB"};
        for (String interval : intervals) {
            for (String valueName : valuesNames) {
                Accumulators.createAccumulator("Mem " + poolName.replaceAll("\\s+", "").replaceAll("PS", "") + valueName + " " + interval, producerName, producerName, valueName, interval);
            }
        }
    }

    public static void createGCAccumulators(List<String> gcNames) {
        ArrayList<String> accumulators = new ArrayList<String>();
        for (String name : gcNames) {
            String currentCountAccName = String.format("GC %s current collection count 1m", name);
            String totalCountAccName = String.format("GC %s total collection count 1m", name);
            String currentTimeAccName = String.format("GC %s current collection time 1m", name);
            String totalTimeAccName = String.format("GC %s total collection time 1m", name);
            accumulators.addAll(Arrays.asList(currentCountAccName, totalCountAccName, currentTimeAccName, totalTimeAccName));
            Accumulators.createAccumulator(currentCountAccName, "GC", name, "CurrentCollectionCount", "1m");
            Accumulators.createAccumulator(totalCountAccName, "GC", name, "TotalCollectionCount", "1m");
            Accumulators.createAccumulator(currentTimeAccName, "GC", name, "CurrentCollectionTime", "1m");
            Accumulators.createAccumulator(totalTimeAccName, "GC", name, "TotalCollectionTime", "1m");
        }
        AccumulatorSetConfig[] accumulatorSets = MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig().getAccumulatorSets();
        if (accumulatorSets == null) {
            accumulatorSets = new AccumulatorSetConfig[]{};
        }
        ArrayList<AccumulatorSetConfig> setConfig = new ArrayList<AccumulatorSetConfig>(Arrays.asList(accumulatorSets));
        AccumulatorSetConfig gcSet = new AccumulatorSetConfig();
        gcSet.setName("GC 1 minute");
        gcSet.setMode(AccumulatorSetMode.MULTIPLE);
        String[] accNames = new String[accumulators.size()];
        gcSet.setAccumulatorNames(accumulators.toArray(accNames));
        setConfig.add(gcSet);
        AccumulatorSetConfig[] accSets = new AccumulatorSetConfig[setConfig.size()];
        MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig().setAccumulatorSets(setConfig.toArray(accSets));
    }

    public static void setupCPUAccumulators() {
        Accumulators.createAccumulator("CPU Time 1m", "OS", "OS", "CPU Time", "1m", TimeUnit.SECONDS);
        Accumulators.createAccumulator("CPU Time 5m", "OS", "OS", "CPU Time", DEFAULT_INTERVAL, TimeUnit.SECONDS);
        Accumulators.createAccumulator("CPU Time 1h", "OS", "OS", "CPU Time", "1h", TimeUnit.SECONDS);
    }
}

