/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.calltrace;

import java.io.Serializable;
import java.util.Map;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.journey.JourneyConfig;
import net.anotheria.moskito.core.producers.IStatsProducer;

public class CurrentlyTracedCall
implements TracedCall,
Serializable {
    private static final long serialVersionUID = 3099062979275211864L;
    private String name;
    private TraceStep root = new TraceStep("");
    private TraceStep current;
    private long created;
    private Map<String, String> tags;
    private transient JourneyConfig journeyConfig = MoskitoConfigurationHolder.getConfiguration().getJourneyConfig();

    public CurrentlyTracedCall(String aName) {
        this.name = aName;
        this.current = this.root;
        this.created = System.currentTimeMillis();
    }

    @Override
    public boolean callTraced() {
        return true;
    }

    public String toString() {
        return "CurrentlyTracedCall: " + this.name;
    }

    public String toDetails() {
        return this.toString() + ": \n" + this.root.toDetails(1);
    }

    public TraceStep startStep(String call, IStatsProducer producer) {
        TraceStep last = this.current;
        this.current = new TraceStep(call, producer);
        if (last != null) {
            last.addChild(this.current);
        }
        return this.current;
    }

    @Deprecated
    public TraceStep startStep(String call) {
        return this.startStep(call, null);
    }

    public void endStep() {
        this.current = this.current.getParent();
    }

    public String getTrace() {
        return this.root.generateTrace();
    }

    public String getName() {
        return this.name;
    }

    public long getCreated() {
        return this.created;
    }

    public TraceStep getRootStep() {
        return this.root;
    }

    public TraceStep getFirstStep() {
        return this.root.getChildren().get(0);
    }

    public TraceStep getLastStep() {
        return this.root.getLastStep();
    }

    public int getNumberOfSteps() {
        return this.root.getNumberOfIncludedSteps();
    }

    public TraceStep getCurrentStep() {
        return this.current;
    }

    public JourneyConfig getJourneyConfig() {
        return this.journeyConfig;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

