/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.errorhandling;

import com.google.gson.annotations.SerializedName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.moskito.core.config.errorhandling.ErrorCatcherConfig;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe
@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"}, justification="This is the way ConfigureMe works, it provides beans for access")
public class ErrorHandlingConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Configure
    private boolean autoChartErrors = true;
    @Configure
    private String autoChartErrorsInterval = "1m";
    @Configure
    private boolean logErrors = false;
    @SerializedName(value="@catchers")
    @Configure
    private ErrorCatcherConfig[] catchers = new ErrorCatcherConfig[0];
    @Configure
    private int catchersMemoryErrorLimit = 50;
    private transient Map<String, ErrorCatcherConfig> catcherCache = new HashMap<String, ErrorCatcherConfig>();

    public boolean isAutoChartErrors() {
        return this.autoChartErrors;
    }

    public void setAutoChartErrors(boolean autoChartErrors) {
        this.autoChartErrors = autoChartErrors;
    }

    public String getAutoChartErrorsInterval() {
        return this.autoChartErrorsInterval;
    }

    public void setAutoChartErrorsInterval(String autoChartErrorsInterval) {
        this.autoChartErrorsInterval = autoChartErrorsInterval;
    }

    public boolean isLogErrors() {
        return this.logErrors;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }

    public String toString() {
        return "autoChartErrors: " + this.isAutoChartErrors() + ", autoChartErrorsInterval: " + this.getAutoChartErrorsInterval();
    }

    public ErrorCatcherConfig[] getCatchers() {
        return this.catchers;
    }

    public void setCatchers(ErrorCatcherConfig[] catchers) {
        this.catchers = catchers;
    }

    @AfterConfiguration
    public void afterConfiguration() {
        HashMap<String, ErrorCatcherConfig> newCatcherCache = new HashMap<String, ErrorCatcherConfig>();
        if (this.catchers != null && this.catchers.length > 0) {
            for (ErrorCatcherConfig config : this.catchers) {
                newCatcherCache.put(config.getClazz(), config);
            }
        }
        this.catcherCache = newCatcherCache;
    }

    public ErrorCatcherConfig getCatcherConfig(String name) {
        return this.catcherCache.get(name);
    }

    public int getCatchersMemoryErrorLimit() {
        return this.catchersMemoryErrorLimit;
    }

    public void setCatchersMemoryErrorLimit(int catchersMemoryErrorLimit) {
        this.catchersMemoryErrorLimit = catchersMemoryErrorLimit;
    }
}

