/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MoSKitoContext {
    private static InheritableThreadLocal<MoSKitoContext> currentContext = new InheritableThreadLocal<MoSKitoContext>(){

        @Override
        protected MoSKitoContext initialValue() {
            return new MoSKitoContext();
        }
    };
    private HashMap<String, String> tags = new HashMap();
    private HashSet<Throwable> seenErrors = new HashSet();
    private AtomicBoolean errorOccured = new AtomicBoolean(false);

    public static MoSKitoContext get() {
        return (MoSKitoContext)currentContext.get();
    }

    public static void addTag(String tagName, String tagValue) {
        MoSKitoContext.get().tags.put(tagName, tagValue);
    }

    public static Map<String, String> getTags() {
        return (Map)MoSKitoContext.get().tags.clone();
    }

    public boolean markErrorAndReturnIfErrorAlreadyHappenedBefore() {
        return this.errorOccured.getAndSet(true);
    }

    public void reset() {
        this.tags = new HashMap();
        this.errorOccured = new AtomicBoolean(false);
        this.seenErrors = new HashSet();
    }

    public static void cleanup() {
        MoSKitoContext.get().reset();
        currentContext.remove();
    }

    public boolean seenErrorAlready(Throwable throwable) {
        if (this.seenErrors.contains(throwable)) {
            return true;
        }
        this.seenErrors.add(throwable);
        return false;
    }
}

