/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.value.StatCaptionBean;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.util.sorter.IComparable;

public abstract class AbstractDecorator<S extends IStats>
implements IDecorator<S> {
    protected static final long MB = 0x100000L;
    private List<StatCaptionBean> captions;
    private String name;

    protected AbstractDecorator(String aName, String[] captionStrings, String[] shortExplanationStrings, String[] explanationStrings) {
        this.name = aName;
        this.captions = new ArrayList<StatCaptionBean>(captionStrings.length);
        for (int i = 0; i < captionStrings.length; ++i) {
            this.captions.add(new StatCaptionBean(captionStrings[i], shortExplanationStrings[i], explanationStrings[i]));
        }
    }

    @Override
    public List<StatCaptionBean> getCaptions() {
        return this.captions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int compareTo(IComparable anotherComparable, int method) {
        return this.name.compareToIgnoreCase(((IDecorator)anotherComparable).getName());
    }

    @Override
    public String getExplanation(String caption) {
        for (StatCaptionBean c : this.captions) {
            if (!c.getCaption().equals(caption)) continue;
            return c.getExplanation();
        }
        return "Sorry, no explanation available";
    }
}

