/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.DoubleValueAO;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.ErrorStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class ErrorStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"Initial", "Total", "Rethrown", "AVG Rethrown", "Max initial per Minute", "Max total per Minute", "Max rethrown per Minute"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Number of initial occurrences", "Number of total occurrences", "Number of times this exception was rethrown", "Average number of times each exception has been rethrown", "Max number of initial occurrences per minute reached", "Max number of total occurrences per minute reached", "Max number of total rethrows per minute reached"};
    private static final String[] EXPLANATIONS = new String[]{"Number of occurrences of this Exception/Error/Throwable object when it was initial (first) error in the processing", "Number of total occurrences of this Exception/Error/Throwable object, regardless if it was initial or followup error. It also includes initial errors.", "Number of times this exception was uncaught and rethrown by an enclosing component either directly with throw, or indirectly - uncaught.", "Average number of times each exception has been rethrown", "Maximal number of occurrences of this Exception/Error/Throwable object when it was initial (first) error in the processing that was reached in a single minute.", "Maximal number of total occurrences of this Exception/Error/Throwable object, regardless if it was initial or followup error. It also includes initial errors. This value is max value reached per minute", "MAximal Number of times this exception was uncaught and rethrown by an enclosing component either directly with throw, or indirectly - uncaught."};

    public ErrorStatsDecorator() {
        super("Errors", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        ErrorStats stats = (ErrorStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getInitial(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getTotal(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getRethrown(interval)));
        ret.add(new DoubleValueAO(CAPTIONS[i++], (double)stats.getRethrown(interval) / (double)stats.getTotal(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], ErrorStatsDecorator.mapToLong(stats.getMaxInitial(interval))));
        ret.add(new LongValueAO(CAPTIONS[i++], ErrorStatsDecorator.mapToLong(stats.getMaxTotal(interval))));
        ret.add(new LongValueAO(CAPTIONS[i++], ErrorStatsDecorator.mapToLong(stats.getMaxRethrown(interval))));
        return ret;
    }

    private static final long mapToLong(int value) {
        return value == Integer.MAX_VALUE ? Long.MAX_VALUE : (value == Integer.MIN_VALUE ? Long.MIN_VALUE : (long)value);
    }
}

