/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.GCStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class GCStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"CurrentCollectionCount", "TotalCollectionCount", "CurrentCollectionTime", "TotalCollectionTime"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Current collection count", "Total collection count", "Current collection time", "Total collection time"};
    private static final String[] EXPLANATIONS = new String[]{"Total number of collections that have occurred for interval", "Total number of collections that have occurred from start", "Approximate accumulated collection elapsed time in milliseconds for interval", "Approximate accumulated collection elapsed time in milliseconds from start"};

    public GCStatsDecorator() {
        this("GC");
    }

    public GCStatsDecorator(String aName) {
        super(aName, CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        GCStats stats = (GCStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCurrentCollectionCount(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getTotalCollectionCount(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCurrentCollectionTime(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getTotalCollectionTime(interval)));
        return ret;
    }
}

