/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.value;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.sorter.IComparable;

public class DoubleValueAO
extends StatValueAO {
    private static final long serialVersionUID = -6016200076708550962L;
    private double doubleValue;
    private String doubleAsString;
    private static DecimalFormat decimalFormat = DoubleValueAO.createDecimalFormat();

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return decimalFormat;
    }

    public DoubleValueAO(String name, double aValue) {
        super(name);
        this.doubleValue = !Double.isInfinite(aValue) ? (double)Math.round(aValue * 1000.0) / 1000.0 : aValue;
        this.doubleAsString = decimalFormat.format(this.doubleValue);
    }

    @Override
    public String getValue() {
        return this.doubleAsString;
    }

    @Override
    public String getType() {
        return "double";
    }

    public int compareTo(IComparable anotherComparable, int ignored) {
        return BasicComparable.compareDouble((double)this.doubleValue, (double)((DoubleValueAO)anotherComparable).doubleValue);
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.doubleValue);
    }
}

