/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.journey;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;

public class Journey {
    private String name;
    private List<CurrentlyTracedCall> tracedCalls;
    private boolean active;
    private long createdTimestamp;
    private long lastActivityTimestamp;

    public Journey(String aName) {
        this.name = aName;
        this.createdTimestamp = System.currentTimeMillis();
        this.active = true;
        this.tracedCalls = new ArrayList<CurrentlyTracedCall>();
    }

    public void addUseCase(CurrentlyTracedCall aTracedCall) {
        this.tracedCalls.add(aTracedCall);
        this.lastActivityTimestamp = System.currentTimeMillis();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimestamp;
    }

    public void setLastActivityTimestamp(long lastActivityTimestamp) {
        this.lastActivityTimestamp = lastActivityTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CurrentlyTracedCall> getTracedCalls() {
        return this.tracedCalls;
    }

    public String toString() {
        return this.getName() + " with " + this.getTracedCalls().size() + " calls.";
    }

    public void removeStepByName(String stepName) {
        for (int i = 0; i < this.tracedCalls.size(); ++i) {
            CurrentlyTracedCall ctc = this.tracedCalls.get(i);
            if (!ctc.getName().equals(stepName)) continue;
            this.tracedCalls.remove(i);
            return;
        }
    }

    public CurrentlyTracedCall getStepByName(String stepName) {
        for (int i = 0; i < this.tracedCalls.size(); ++i) {
            CurrentlyTracedCall ctc = this.tracedCalls.get(i);
            if (!ctc.getName().equals(stepName)) continue;
            return ctc;
        }
        return null;
    }
}

