/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.plugins.PluginConfig;
import net.anotheria.moskito.core.config.plugins.PluginsConfig;
import net.anotheria.moskito.core.plugins.MoskitoPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginRepository {
    private static Logger log = LoggerFactory.getLogger(PluginRepository.class);
    private ConcurrentMap<String, MoskitoPlugin> plugins = new ConcurrentHashMap<String, MoskitoPlugin>();
    private ConcurrentMap<String, PluginConfig> configs = new ConcurrentHashMap<String, PluginConfig>();

    public static PluginRepository getInstance() {
        return PluginRepositoryHolder.instance;
    }

    private PluginRepository() {
    }

    private void setup() {
        PluginsConfig config = MoskitoConfigurationHolder.getConfiguration().getPluginsConfig();
        if (config.getPlugins() == null) {
            return;
        }
        for (PluginConfig pc : config.getPlugins()) {
            log.info("Loading plugin " + pc);
            try {
                MoskitoPlugin plugin = (MoskitoPlugin)MoskitoPlugin.class.cast(Class.forName(pc.getClassName()).newInstance());
                plugin.setConfigurationName(pc.getConfigurationName());
                this.addPlugin(pc.getName(), plugin, pc);
            }
            catch (InstantiationException e) {
                log.warn("Couldn't initialize plugin " + pc, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn("Couldn't initialize plugin " + pc, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.warn("Couldn't initialize plugin " + pc, (Throwable)e);
            }
        }
    }

    public void addPlugin(String name, MoskitoPlugin plugin, PluginConfig config) {
        this.plugins.put(name, plugin);
        try {
            plugin.initialize();
            this.configs.put(name, config);
        }
        catch (Exception e) {
            log.warn("couldn't initialize plugin " + name + " - " + plugin + ", removing", (Throwable)e);
            this.plugins.remove(name);
        }
    }

    public void removePlugin(String name) {
        this.configs.remove(name);
        MoskitoPlugin plugin = (MoskitoPlugin)this.plugins.remove(name);
        if (plugin == null) {
            log.warn("Trying to remove not registered plugin " + name);
            return;
        }
        try {
            plugin.deInitialize();
        }
        catch (Exception e) {
            log.warn("Couldn't de-initialize plugin " + name + " - " + plugin, (Throwable)e);
        }
    }

    public List<String> getPluginNames() {
        ArrayList<String> ret = new ArrayList<String>(this.plugins.keySet());
        return ret;
    }

    public List<MoskitoPlugin> getPlugins() {
        ArrayList<MoskitoPlugin> ret = new ArrayList<MoskitoPlugin>(this.plugins.values());
        return ret;
    }

    public MoskitoPlugin getPlugin(String name) {
        return (MoskitoPlugin)this.plugins.get(name);
    }

    public PluginConfig getConfig(String name) {
        return (PluginConfig)this.configs.get(name);
    }

    private static class PluginRepositoryHolder {
        private static final PluginRepository instance = new PluginRepository();

        private PluginRepositoryHolder() {
        }

        static {
            PluginRepositoryHolder.instance.setup();
        }
    }
}

