/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class GCStats
extends AbstractStats {
    private StatValue currentCollectionCount;
    private StatValue totalCollectionCount;
    private StatValue currentCollectionTime;
    private StatValue totalCollectionTime;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("CurrentCollectionCount", "TotalCollectionCount", "CurrentCollectionTime", "TotalCollectionTime"));

    public GCStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public GCStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.currentCollectionCount = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "currentCollectionCount", selectedIntervals);
        this.totalCollectionCount = StatValueFactory.createStatValue(0, "totalCollectionCount", selectedIntervals);
        this.currentCollectionTime = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "currentCollectionTime", selectedIntervals);
        this.totalCollectionTime = StatValueFactory.createStatValue(0, "totalCollectionTime", selectedIntervals);
        this.addStatValues(this.currentCollectionCount, this.totalCollectionCount, this.currentCollectionTime, this.totalCollectionTime);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" currentCollectionCount: ").append(this.currentCollectionCount.getValueAsLong(intervalName));
        ret.append(" totalCollectionCount: ").append(this.totalCollectionCount.getValueAsLong(intervalName));
        ret.append(" currentCollectionTime: ").append(this.currentCollectionTime.getValueAsLong(intervalName));
        ret.append(" totalCollectionTime: ").append(this.totalCollectionTime.getValueAsLong(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("currentcollectioncount") || valueName.equals("current collection count")) {
            return String.valueOf(this.getCurrentCollectionCount(intervalName));
        }
        if (valueName.equals("totalcollectioncount") || valueName.equals("total collection count")) {
            return String.valueOf(this.getTotalCollectionCount(intervalName));
        }
        if (valueName.equals("currentcollectiontime") || valueName.equals("current collection time")) {
            return String.valueOf(this.getCurrentCollectionTime(intervalName));
        }
        if (valueName.equals("totalcollectiontime") || valueName.equals("total collection time")) {
            return String.valueOf(this.getTotalCollectionTime(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public void update(long aCollectionCount, long aCollectionTime) {
        this.currentCollectionCount.setValueAsLong(aCollectionCount);
        this.totalCollectionCount.setValueAsLong(aCollectionCount);
        this.currentCollectionTime.setValueAsLong(aCollectionTime);
        this.totalCollectionTime.setValueAsLong(aCollectionTime);
    }

    public long getCurrentCollectionCount(String intervalName) {
        return this.currentCollectionCount.getValueAsLong(intervalName);
    }

    public long getTotalCollectionCount(String intervalName) {
        return this.totalCollectionCount.getValueAsLong(intervalName);
    }

    public long getCurrentCollectionTime(String intervalName) {
        return this.currentCollectionTime.getValueAsLong(intervalName);
    }

    public long getTotalCollectionTime(String intervalName) {
        return this.totalCollectionTime.getValueAsLong(intervalName);
    }
}

