/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import net.anotheria.moskito.core.predefined.RequestOrientedStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.BuiltInErrorProducer;

public class ServletStats
extends RequestOrientedStats {
    private StatValue ioExceptions;
    private StatValue servletExceptions;
    private StatValue runtimeExceptions;

    public ServletStats(String aMethodName) {
        super(aMethodName);
        this.initializeMe();
    }

    public ServletStats() {
        this.initializeMe();
    }

    public ServletStats(String aMethodName, Interval[] intervals) {
        super(aMethodName, intervals);
        this.initializeMe();
    }

    private void initializeMe() {
        Long pattern = 0L;
        this.ioExceptions = StatValueFactory.createStatValue(pattern, "ioexceptions", this.getSelectedIntervals());
        this.servletExceptions = StatValueFactory.createStatValue(pattern, "servletExceptions", this.getSelectedIntervals());
        this.runtimeExceptions = StatValueFactory.createStatValue(pattern, "runtimeExceptions", this.getSelectedIntervals());
        this.addStatValues(this.ioExceptions, this.servletExceptions, this.runtimeExceptions);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder ret = new StringBuilder();
        ret.append(" TR: ").append(this.getTotalRequests(intervalName));
        ret.append(" TT: ").append(timeUnit.transformNanos(this.getTotalTime(intervalName)));
        ret.append(" CR: ").append(this.getCurrentRequests(intervalName));
        ret.append(" MCR: ").append(this.getMaxCurrentRequests(intervalName));
        ret.append(" ERR: ").append(this.getErrors(intervalName));
        ret.append(" IOExc: ").append(this.ioExceptions.getValueAsLong(intervalName));
        ret.append(" SEExc: ").append(this.servletExceptions.getValueAsLong(intervalName));
        ret.append(" RTExc: ").append(this.runtimeExceptions.getValueAsLong(intervalName));
        ret.append(" Last: ").append(timeUnit.transformNanos(this.getLastRequest(intervalName)));
        ret.append(" Min: ").append(timeUnit.transformNanos(this.getMinTime(intervalName)));
        ret.append(" Max: ").append(timeUnit.transformNanos(this.getMaxTime(intervalName)));
        ret.append(" Avg: ").append(this.getAverageRequestDuration(intervalName, timeUnit));
        return ret.toString();
    }

    public void notifyServletException(Throwable t) {
        this.servletExceptions.increase();
        BuiltInErrorProducer.getInstance().notifyError(t);
    }

    public void notifyIOException(Throwable t) {
        this.ioExceptions.increase();
        BuiltInErrorProducer.getInstance().notifyError(t);
    }

    public void notifyRuntimeException(Throwable t) {
        this.runtimeExceptions.increase();
        BuiltInErrorProducer.getInstance().notifyError(t);
    }

    public long getIoExceptions() {
        return this.getIoExceptions(null);
    }

    public long getRuntimeExceptions() {
        return this.getRuntimeExceptions(null);
    }

    public long getServletExceptions() {
        return this.getServletExceptions(null);
    }

    public long getIoExceptions(String interval) {
        return this.ioExceptions.getValueAsLong(interval);
    }

    public long getRuntimeExceptions(String interval) {
        return this.runtimeExceptions.getValueAsLong(interval);
    }

    public long getServletExceptions(String interval) {
        return this.servletExceptions.getValueAsLong(interval);
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("ioexc")) {
            return String.valueOf(this.ioExceptions.getValueAsLong(intervalName));
        }
        if (valueName.equals("seexc")) {
            return String.valueOf(this.servletExceptions.getValueAsLong(intervalName));
        }
        if (valueName.equals("rtexc")) {
            return String.valueOf(this.runtimeExceptions.getValueAsLong(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }
}

