/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.predefined.AbstractMemoryPoolStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.IMemoryPoolStats;
import net.anotheria.moskito.core.predefined.MemoryPoolStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.TimeUnit;

public class VirtualMemoryPoolStats
extends AbstractMemoryPoolStats
implements IMemoryPoolStats {
    private List<MemoryPoolStats> realStats = new ArrayList<MemoryPoolStats>();

    public VirtualMemoryPoolStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public VirtualMemoryPoolStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public VirtualMemoryPoolStats(String aName, Interval[] selectedIntervals) {
        super(aName);
    }

    public void addStats(MemoryPoolStats stats) {
        this.realStats.add(stats);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" INIT: ").append(this.getInit(intervalName));
        b.append(" MIN USED: ").append(this.getMinUsed(intervalName));
        b.append(" USED: ").append(this.getUsed(intervalName));
        b.append(" MAX USED: ").append(this.getMaxUsed(intervalName));
        b.append(" MIN COMMITED: ").append(this.getMinCommited(intervalName));
        b.append(" COMMITED: ").append(this.getCommited(intervalName));
        b.append(" MAX COMMITED: ").append(this.getMaxCommited(intervalName));
        b.append(" MAX: ").append(this.getMax(intervalName));
        return b.toString();
    }

    @Override
    public long getInit(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getInit(intervalName);
        }
        return ret;
    }

    @Override
    public long getUsed(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getUsed(intervalName);
        }
        return ret;
    }

    @Override
    public long getMinUsed(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getMinUsed(intervalName);
        }
        return ret;
    }

    @Override
    public long getMaxUsed(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getMaxUsed(intervalName);
        }
        return ret;
    }

    @Override
    public long getCommited(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getCommited(intervalName);
        }
        return ret;
    }

    @Override
    public long getMinCommited(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getMinCommited(intervalName);
        }
        return ret;
    }

    @Override
    public long getMaxCommited(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getMaxCommited(intervalName);
        }
        return ret;
    }

    @Override
    public long getMax(String intervalName) {
        long ret = 0L;
        for (MemoryPoolStats s : this.realStats) {
            ret += s.getMax(intervalName);
        }
        return ret;
    }

    @Override
    public long getFree(String intervalName) {
        return this.getCommited(intervalName) - this.getUsed(intervalName);
    }
}

