/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.snapshot;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistryAPI;
import net.anotheria.moskito.core.registry.ProducerRegistryAPIFactory;
import net.anotheria.moskito.core.snapshot.ProducerSnapshot;
import net.anotheria.moskito.core.snapshot.SnapshotConsumer;
import net.anotheria.moskito.core.snapshot.SnapshotCreator;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.IntervalRegistryListener;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import net.anotheria.util.queue.IQueueWorker;
import net.anotheria.util.queue.QueuedProcessor;
import net.anotheria.util.queue.UnrecoverableQueueOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotRepository {
    private final List<SnapshotConsumer> consumers = new CopyOnWriteArrayList<SnapshotConsumer>();
    private IProducerRegistryAPI producerRegistryAPI;
    private QueuedProcessor<ProducerSnapshot> snapshotQueuedProcessor = new QueuedProcessor("SnapshotConsumers", (IQueueWorker)new IQueueWorker<ProducerSnapshot>(){

        public void doWork(ProducerSnapshot producerSnapshot) throws Exception {
            for (SnapshotConsumer consumer : SnapshotRepository.this.consumers) {
                try {
                    consumer.consumeSnapshot(producerSnapshot);
                }
                catch (Exception e) {
                    log.warn("consumer " + consumer + " failed to process snapshot " + producerSnapshot);
                }
            }
        }
    }, 1000, 50L, log);
    private static Logger log = LoggerFactory.getLogger(SnapshotRepository.class);
    private boolean inTestMode = false;

    private SnapshotRepository() {
        this.snapshotQueuedProcessor.start();
        this.inTestMode = System.getProperty("JUNITTEST", "false").equals("true");
        this.producerRegistryAPI = new ProducerRegistryAPIFactory().createProducerRegistryAPI();
        List<Interval> intervals = IntervalRegistry.getInstance().getIntervals();
        for (Interval i : intervals) {
            i.addSecondaryIntervalListener(new SRIntervalListener());
        }
        IntervalRegistry.getInstance().addIntervalRegistryListener(new SRIntervalRegistryListener());
    }

    public static SnapshotRepository getInstance() {
        return SnapshotRepositoryInstanceHolder.instance;
    }

    private void intervalUpdated(Interval aCaller) {
        if (this.consumers.size() == 0) {
            return;
        }
        List<IStatsProducer> producers = this.producerRegistryAPI.getAllProducers();
        if (producers.size() == 0) {
            return;
        }
        String intervalName = aCaller.getName();
        for (IStatsProducer producer : producers) {
            ProducerSnapshot snapshot = SnapshotCreator.createSnapshot(producer, intervalName);
            try {
                this.snapshotQueuedProcessor.addToQueue((Object)snapshot);
            }
            catch (UnrecoverableQueueOverflowException e) {
                log.warn("Queue overflow - throw away snapshot: " + snapshot, (Throwable)e);
            }
        }
        if (this.inTestMode) {
            while (this.snapshotQueuedProcessor.getQueueSize() != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void addConsumer(SnapshotConsumer consumer) {
        if (this.consumers.contains(consumer)) {
            this.consumers.remove(consumer);
        }
        this.consumers.add(consumer);
    }

    public void removeConsumer(SnapshotConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private static class SnapshotRepositoryInstanceHolder {
        private static final SnapshotRepository instance = new SnapshotRepository();

        private SnapshotRepositoryInstanceHolder() {
        }
    }

    private static class SRIntervalRegistryListener
    implements IntervalRegistryListener {
        private SRIntervalRegistryListener() {
        }

        @Override
        public void intervalCreated(Interval aInterval) {
            aInterval.addSecondaryIntervalListener(new SRIntervalListener());
        }
    }

    private static class SRIntervalListener
    implements IIntervalListener {
        private SRIntervalListener() {
        }

        @Override
        public void intervalUpdated(Interval aCaller) {
            SnapshotRepository.getInstance().intervalUpdated(aCaller);
        }
    }
}

