/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats;

public enum TimeUnit {
    NANOSECONDS(1L),
    MICROSECONDS(1000L),
    MILLISECONDS(1000L * TimeUnit.MICROSECONDS.factor),
    SECONDS(1000L * TimeUnit.MILLISECONDS.factor);

    private long factor;

    private TimeUnit(long aFactor) {
        this.factor = aFactor;
    }

    public long transformNanos(long nanos) {
        return nanos / this.factor;
    }

    public double transformMillis(double millis) {
        switch (this) {
            case NANOSECONDS: {
                return millis * (double)TimeUnit.MILLISECONDS.factor;
            }
            case MICROSECONDS: {
                return millis * (double)TimeUnit.MICROSECONDS.factor;
            }
            case SECONDS: {
                return millis / 1000.0;
            }
        }
        return millis;
    }

    public long transformMillis(long millis) {
        switch (this) {
            case NANOSECONDS: {
                return millis * TimeUnit.MILLISECONDS.factor;
            }
            case MICROSECONDS: {
                return millis * TimeUnit.MICROSECONDS.factor;
            }
            case SECONDS: {
                return millis / 1000L;
            }
        }
        return millis;
    }

    public static final TimeUnit fromString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("TimeUnit name can't be null");
        }
        String orig = str = str.toUpperCase();
        try {
            TimeUnit ret = TimeUnit.valueOf(str);
            return ret;
        }
        catch (IllegalArgumentException e) {
            if (!str.endsWith("S")) {
                str = str + "S";
            }
            str = str + "ECONDS";
            try {
                TimeUnit ret = TimeUnit.valueOf(str);
                return ret;
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("No enum const class net.anotheria.moskito.core.stats.TimeUnit, tried " + orig + " and " + str);
            }
        }
    }
}

