/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.impl.AbstractValueHolder;

public class DoubleValueHolder
extends AbstractValueHolder {
    public static final double DEFAULT_DEFAULT_VALUE = 0.0;
    private double currentValue;
    private double lastValue;
    private double defaultValue;

    public DoubleValueHolder(Interval aInterval) {
        super(aInterval);
    }

    @Override
    public void intervalUpdated(Interval aCaller) {
        this.lastValue = this.currentValue;
        this.currentValue = this.defaultValue;
    }

    @Override
    public void reset() {
        this.currentValue = this.defaultValue;
        this.lastValue = this.defaultValue;
    }

    @Override
    public void increase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decrease() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getValueAsInt() {
        return (int)Math.rint(this.lastValue);
    }

    @Override
    public long getValueAsLong() {
        return Math.round(this.lastValue);
    }

    @Override
    public double getValueAsDouble() {
        return this.lastValue;
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.lastValue);
    }

    @Override
    public int getCurrentValueAsInt() {
        return (int)Math.rint(this.currentValue);
    }

    @Override
    public long getCurrentValueAsLong() {
        return Math.round(this.currentValue);
    }

    @Override
    public double getCurrentValueAsDouble() {
        return this.currentValue;
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(this.currentValue);
    }

    @Override
    public void setValueAsInt(int aValue) {
        this.currentValue = aValue;
    }

    @Override
    public void setValueAsString(String aValue) {
        this.currentValue = Double.parseDouble(aValue);
    }

    @Override
    public void setValueAsLong(long aValue) {
        this.currentValue = aValue;
    }

    @Override
    public void setValueAsDouble(double aValue) {
        this.currentValue = aValue;
    }

    @Override
    public void increaseByInt(int aValue) {
        this.currentValue += (double)aValue;
    }

    @Override
    public void increaseByLong(long aValue) {
        this.currentValue += (double)aValue;
    }

    @Override
    public void increaseByDouble(double aValue) {
        this.currentValue += aValue;
    }

    @Override
    public void decreaseByInt(int aValue) {
        this.currentValue -= (double)aValue;
    }

    @Override
    public void decreaseByLong(long aValue) {
        this.currentValue -= (double)aValue;
    }

    @Override
    public void decreaseByDouble(double aValue) {
        this.currentValue -= aValue;
    }

    @Override
    public void setDefaultValueAsInt(int aValue) {
        this.defaultValue = aValue;
    }

    @Override
    public void setDefaultValueAsLong(long aValue) {
        this.defaultValue = aValue;
    }

    @Override
    public void setDefaultValueAsDouble(double aValue) {
        this.defaultValue = aValue;
    }
}

