/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import net.anotheria.moskito.core.stats.IValueHolderFactory;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.impl.CounterValueHolderFactory;
import net.anotheria.moskito.core.stats.impl.DiffLongValueHolderFactory;
import net.anotheria.moskito.core.stats.impl.DoubleValueHolderFactory;
import net.anotheria.moskito.core.stats.impl.IntValueHolderFactory;
import net.anotheria.moskito.core.stats.impl.LongValueHolderFactory;
import net.anotheria.moskito.core.stats.impl.StringValueHolderFactory;

final class StatValueTypeUtility {
    private static LongValueHolderFactory longValueHolderFactory = new LongValueHolderFactory();
    private static IntValueHolderFactory intValueHolderFactory = new IntValueHolderFactory();
    private static StringValueHolderFactory stringValueHolderFactory = new StringValueHolderFactory();
    private static CounterValueHolderFactory counterValueHolderFactory = new CounterValueHolderFactory();
    private static DoubleValueHolderFactory doubleValueHolderFactory = new DoubleValueHolderFactory();
    private static DiffLongValueHolderFactory diffLongValueHolderFactory = new DiffLongValueHolderFactory();

    protected static IValueHolderFactory createValueHolderFactory(StatValueTypes aType) {
        switch (aType) {
            case LONG: {
                return longValueHolderFactory;
            }
            case INT: {
                return intValueHolderFactory;
            }
            case STRING: {
                return stringValueHolderFactory;
            }
            case COUNTER: {
                return counterValueHolderFactory;
            }
            case DOUBLE: {
                return doubleValueHolderFactory;
            }
            case DIFFLONG: {
                return diffLongValueHolderFactory;
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)aType)));
    }

    protected static StatValueTypes object2type(Object anObject) {
        if (anObject instanceof Long) {
            return StatValueTypes.LONG;
        }
        if (anObject instanceof Integer) {
            return StatValueTypes.INT;
        }
        if (anObject instanceof String) {
            return StatValueTypes.STRING;
        }
        if (anObject instanceof Double) {
            return StatValueTypes.DOUBLE;
        }
        throw new AssertionError((Object)("Invalid class for object2type mapping: " + anObject.getClass()));
    }

    private StatValueTypeUtility() {
    }
}

