/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.errorhandling.ErrorCatcherConfig;
import net.anotheria.moskito.core.config.errorhandling.ErrorHandlingConfig;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.helper.AutoTieAbleProducer;
import net.anotheria.moskito.core.predefined.ErrorStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.ErrorCatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuiltInErrorProducer
extends AbstractBuiltInProducer<ErrorStats>
implements IStatsProducer<ErrorStats>,
BuiltInProducer,
AutoTieAbleProducer {
    private static Logger log = LoggerFactory.getLogger(BuiltInErrorProducer.class);
    private ConcurrentHashMap<Class, ErrorStats> statsMap = null;
    private CopyOnWriteArrayList<ErrorStats> statsList = null;
    private ErrorStats cumulatedStats;
    private static Logger globalErrorLogger = LoggerFactory.getLogger((String)"MoSKitoCaughtErrors");
    private ConcurrentMap<Class, ErrorCatcher> catchers;
    private ConcurrentMap<Class, LoggerWrapper> wrappers;

    private BuiltInErrorProducer() {
        this.init();
    }

    private void init() {
        this.statsMap = new ConcurrentHashMap();
        this.statsList = new CopyOnWriteArrayList();
        this.cumulatedStats = new ErrorStats("cumulated");
        this.statsList.add(this.cumulatedStats);
        this.catchers = new ConcurrentHashMap<Class, ErrorCatcher>();
        this.wrappers = new ConcurrentHashMap<Class, LoggerWrapper>();
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
        AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors.Cumulated.Total", "total", "cumulated"));
        AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors.Cumulated.Initial", "initial", "cumulated"));
    }

    private AccumulatorDefinition createAccumulatorDefinition(String name, String valueName, String statName) {
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(name);
        definition.setProducerName(this.getProducerId());
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig().getAutoChartErrorsInterval());
        return definition;
    }

    public static BuiltInErrorProducer getInstance() {
        return ErrorProducerHolder.instance;
    }

    @Override
    public List<ErrorStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getProducerId() {
        return "ErrorProducer";
    }

    @Override
    public String getCategory() {
        return "errors";
    }

    public void notifyError(Throwable throwable) {
        Class<?> clazz;
        ErrorStats existingStats;
        ErrorCatcherConfig catcherConfig;
        if (MoSKitoContext.get().seenErrorAlready(throwable)) {
            this.cumulatedStats.addRethrown();
            Class<?> clazz2 = throwable.getClass();
            ErrorStats existingStats2 = this.statsMap.get(clazz2);
            if (existingStats2 != null) {
                existingStats2.addRethrown();
            } else {
                log.error("This can't happen, existing stats are null for " + throwable.getClass());
            }
            return;
        }
        boolean isInitialError = !MoSKitoContext.get().markErrorAndReturnIfErrorAlreadyHappenedBefore();
        this.cumulatedStats.addError(isInitialError);
        ErrorHandlingConfig config = MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig();
        if (config.isLogErrors()) {
            globalErrorLogger.error("auto-caught: " + throwable.getMessage(), throwable);
        }
        if ((catcherConfig = config.getCatcherConfig(throwable.getClass().getName())) != null) {
            if (catcherConfig.getTarget().keepInMemory()) {
                ErrorCatcher catcher = (ErrorCatcher)this.catchers.get(throwable.getClass());
                if (catcher == null) {
                    ErrorCatcher newCatcher = new ErrorCatcher(throwable.getClass());
                    ErrorCatcher oldCatcher = this.catchers.putIfAbsent(throwable.getClass(), newCatcher);
                    catcher = oldCatcher == null ? newCatcher : oldCatcher;
                }
                catcher.add(throwable);
            }
            if (catcherConfig.getTarget().log()) {
                LoggerWrapper wrapper = (LoggerWrapper)this.wrappers.get(throwable.getClass());
                if (wrapper == null) {
                    wrapper = new LoggerWrapper();
                    LoggerWrapper old = this.wrappers.putIfAbsent(throwable.getClass(), wrapper);
                    if (old == null) {
                        wrapper.setLogger(catcherConfig.getParameter());
                    } else {
                        wrapper = old;
                    }
                }
                if (wrapper.getLogger() != null) {
                    wrapper.getLogger().error("caught " + throwable.getClass(), throwable);
                }
            }
        }
        if ((existingStats = this.statsMap.get(clazz = throwable.getClass())) != null) {
            existingStats.addError(isInitialError);
            return;
        }
        ErrorStats newErrorStatsObject = new ErrorStats(clazz.getSimpleName());
        ErrorStats oldErrorStatsObject = this.statsMap.putIfAbsent(clazz, newErrorStatsObject);
        if (oldErrorStatsObject != null) {
            oldErrorStatsObject.addError(isInitialError);
            return;
        }
        newErrorStatsObject.addError(isInitialError);
        this.statsList.add(newErrorStatsObject);
        if (config.isAutoChartErrors()) {
            String chartName = throwable.getClass().getSimpleName();
            AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors." + chartName + ".Total", "total", chartName));
            AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors." + chartName + ".Initial", "initial", chartName));
        }
    }

    ErrorStats testingGetStatsForError(Class errorClazz) {
        return this.statsMap.get(errorClazz);
    }

    ErrorStats testingGetCumulatedStats() {
        return this.cumulatedStats;
    }

    void testingReset() {
        this.init();
    }

    public ErrorCatcher getCatcher(Class clazz) {
        return (ErrorCatcher)this.catchers.get(clazz);
    }

    public List<ErrorCatcher> getCatchers() {
        ArrayList<ErrorCatcher> ret = new ArrayList<ErrorCatcher>();
        ret.addAll(this.catchers.values());
        return ret;
    }

    static class LoggerWrapper {
        private volatile Logger log;

        public void setLogger(String name) {
            this.log = LoggerFactory.getLogger((String)name);
        }

        Logger getLogger() {
            return this.log;
        }

        public String toString() {
            return "LoggerWrapper " + this.log;
        }
    }

    private static class ErrorProducerHolder {
        static BuiltInErrorProducer instance = new BuiltInErrorProducer();

        private ErrorProducerHolder() {
        }
    }
}

