/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.util.CaughtError;

public class ErrorCatcher {
    private volatile List<CaughtError> errorList = new CopyOnWriteArrayList<CaughtError>();
    private Class clazz;

    ErrorCatcher(Class aClazz) {
        this.clazz = aClazz;
    }

    public void add(Throwable throwable) {
        int limit = MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig().getCatchersMemoryErrorLimit();
        int tolerableLimit = (int)((double)limit * 1.1);
        if (this.errorList.size() > tolerableLimit) {
            this.trimList(limit);
        }
        this.errorList.add(new CaughtError(throwable));
    }

    public List<CaughtError> getErrorList() {
        return this.errorList;
    }

    synchronized void trimList(int toLimit) {
        int listSize = this.errorList.size();
        CopyOnWriteArrayList<CaughtError> newList = new CopyOnWriteArrayList<CaughtError>();
        for (int i = listSize - toLimit; i < listSize; ++i) {
            newList.add(this.errorList.get(i));
        }
        this.errorList = newList;
    }

    public String getName() {
        return this.clazz.getName();
    }
}

