/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.producers.MBeanProducerConfig;
import net.anotheria.moskito.core.config.producers.MBeanProducerDomainConfig;
import net.anotheria.moskito.core.predefined.MBeanStatsList;
import net.anotheria.moskito.core.producers.GenericStats;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.SimpleStatsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanProducerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanProducerFactory.class);

    public static Iterable<SimpleStatsProducer<GenericStats>> buildProducers() {
        ArrayList<SimpleStatsProducer<GenericStats>> result = new ArrayList<SimpleStatsProducer<GenericStats>>();
        for (MBeanServer server : MBeanProducerFactory.getServers()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("handle MBean-Server: " + server.toString());
            }
            MBeanProducerFactory.handleServer(result, server);
        }
        return result;
    }

    public static String normalize(String s) {
        if (s == null || s.trim().isEmpty()) {
            return "unspecific";
        }
        return s.replace(':', '/').replace('=', '-').replace(',', '|').replace('\"', '\'').replace('#', '-');
    }

    private static boolean checkClasses(ObjectInstance mBean, MBeanProducerDomainConfig domainConfig) {
        String[] classes = domainConfig.getClasses();
        if (classes == null || classes.length == 0) {
            return true;
        }
        String mBeanClass = mBean.getClassName();
        for (String className : classes) {
            if (!mBeanClass.equals(className)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDomain(ObjectInstance mBean) {
        ObjectName mBeanName = mBean.getObjectName();
        String domain = mBeanName.getDomain();
        if (domain.startsWith("moskito.")) {
            return false;
        }
        MBeanProducerConfig conf = MoskitoConfigurationHolder.getConfiguration().getMbeanProducersConfig();
        MBeanProducerDomainConfig[] domainConfigs = conf.getDomains();
        if (domainConfigs == null || domainConfigs.length == 0) {
            return true;
        }
        for (MBeanProducerDomainConfig domainConfig : domainConfigs) {
            if (!domainConfig.getName().equalsIgnoreCase(domain)) continue;
            return MBeanProducerFactory.checkClasses(mBean, domainConfig);
        }
        return false;
    }

    private static Iterable<ObjectInstance> getObjectInstances(MBeanServer server) {
        return server.queryMBeans(null, null);
    }

    private static Iterable<MBeanServer> getServers() {
        ManagementFactory.getPlatformMBeanServer();
        return MBeanServerFactory.findMBeanServer(null);
    }

    private static void handleServer(Collection<SimpleStatsProducer<GenericStats>> result, MBeanServer server) {
        IProducerRegistry producerRegistry = ProducerRegistryFactory.getProducerRegistryInstance();
        MBeanProducerConfig conf = MoskitoConfigurationHolder.getConfiguration().getMbeanProducersConfig();
        for (ObjectInstance mbean : MBeanProducerFactory.getObjectInstances(server)) {
            if (!MBeanProducerFactory.checkDomain(mbean)) continue;
            ObjectName mBeanName = mbean.getObjectName();
            String canonicalName = mBeanName.getCanonicalName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("handle MBean: " + canonicalName);
            }
            String producerId = MBeanProducerFactory.normalize(canonicalName);
            String subsystem = MBeanProducerFactory.normalize(mBeanName.getDomain());
            MBeanStatsList statsList = new MBeanStatsList(server, mBeanName, conf.isUpdateAutomatically(), conf.getDelayBeforeFirstUpdate());
            SimpleStatsProducer<GenericStats> p = new SimpleStatsProducer<GenericStats>(producerId, "MBean", subsystem, statsList);
            result.add(p);
            if (!conf.isRegisterAutomatically()) continue;
            producerRegistry.registerProducer(p);
        }
    }

    private MBeanProducerFactory() {
    }
}

