/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.anotheria.moskito.core.util.storage.StorageWrapper;

public class MapStorageWrapper<K, V>
implements StorageWrapper<K, V> {
    private Map<K, V> map;

    public MapStorageWrapper(Map<K, V> aMap) {
        this.map = aMap;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> aMap) {
        this.map.putAll(aMap);
    }

    @Override
    public void putAll(StorageWrapper<? extends K, ? extends V> anotherWrapper) {
        if (!(anotherWrapper instanceof MapStorageWrapper)) {
            throw new RuntimeException("Unsupported operation putAll on " + anotherWrapper + ", class: " + anotherWrapper.getClass());
        }
        this.map.putAll(((MapStorageWrapper)anotherWrapper).getMap());
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Collection<K> keys() {
        return this.map.keySet();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    private Map<K, V> getMap() {
        return this.map;
    }

    public String toString() {
        return "wrapped: " + this.getMap().toString();
    }

    @Override
    public Map<K, V> toMap() {
        return this.fillMap(new HashMap(this.size()));
    }

    @Override
    public Map<K, V> fillMap(Map<K, V> toFill) {
        toFill.putAll(this.map);
        return toFill;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

