/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.helper.TieableDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorDefinition
extends TieableDefinition {
    private static final long serialVersionUID = 4618934362540708598L;
    private int accumulationAmount;
    private static Logger log = LoggerFactory.getLogger(AccumulatorDefinition.class);

    public AccumulatorDefinition() {
        try {
            this.accumulationAmount = MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig().getAccumulationAmount();
        }
        catch (Exception e) {
            this.accumulationAmount = 200;
            log.warn("couldn't read default accumulation amount, set to " + this.accumulationAmount, (Throwable)e);
        }
    }

    public int getMaxAmountOfAccumulatedItems() {
        return this.getAccumulationAmount() + this.getAccumulationAmount() / 10;
    }

    public int getAccumulationAmount() {
        return this.accumulationAmount;
    }

    public void setAccumulationAmount(int accumulationAmount) {
        this.accumulationAmount = accumulationAmount;
    }

    @Override
    public String toString() {
        return super.toString() + " Max: " + this.accumulationAmount;
    }
}

