/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.moskito.core.accumulation.Accumulator;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.accumulators.AccumulatorSetConfig;
import net.anotheria.moskito.core.config.accumulators.AccumulatorSetMode;
import net.anotheria.moskito.core.stats.TimeUnit;

public final class Accumulators {
    public static final String DEFAULT_INTERVAL = "5m";

    private Accumulators() {
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName, TimeUnit timeUnit) {
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(name);
        definition.setProducerName(producerName);
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(intervalName);
        Accumulator acc = AccumulatorRepository.getInstance().createAccumulator(definition);
        return acc;
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName) {
        return Accumulators.createAccumulator(name, producerName, statName, valueName, intervalName, TimeUnit.MILLISECONDS);
    }

    public static void createServiceAVGAccumulator(String name, String producerName) {
        Accumulators.createServiceAVGAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceAVGAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "AVG", interval);
    }

    public static void createServiceREQAccumulator(String name, String producerName) {
        Accumulators.createServiceREQAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceREQAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "REQ", interval);
    }

    public static void createUrlAVGAccumulator(String name, String url) {
        Accumulators.createUrlAVGAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlAVGAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "AVG", interval);
    }

    public static void createUrlREQAccumulator(String name, String url) {
        Accumulators.createUrlREQAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlREQAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "REQ", interval);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url) {
        Accumulators.createUrlTotalTimeAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURI", url, "time", interval);
    }

    public static void createMemoryPoolAccumulator(String poolName, String producerName) {
        String[] intervals = new String[]{"1m", DEFAULT_INTERVAL, "1h"};
        String[] valuesNames = new String[]{"Free", "Free MB", "Used", "Used MB"};
        for (String interval : intervals) {
            for (String valueName : valuesNames) {
                Accumulators.createAccumulator("Mem " + poolName.replaceAll("\\s+", "").replaceAll("PS", "") + valueName + " " + interval, producerName, producerName, valueName, interval);
            }
        }
    }

    public static void createGCAccumulators(List<String> gcNames) {
        ArrayList<String> accumulators = new ArrayList<String>();
        String producerName = "GC";
        for (String name : gcNames) {
            String collectionCountAccName = String.format("GC %s collection count 1m", name);
            String totalCollectionCountAccName = String.format("GC %s total collection count", name);
            String collectionTimeAccName = String.format("GC %s collection time 1m", name);
            String totalCollectionTimeAccName = String.format("GC %s total collection time", name);
            accumulators.addAll(Arrays.asList(collectionCountAccName, collectionTimeAccName));
            Accumulators.createAccumulator(collectionCountAccName, producerName, name, "CollectionCount", "1m");
            Accumulators.createAccumulator(totalCollectionCountAccName, producerName, name, "CollectionCount", "default");
            Accumulators.createAccumulator(collectionTimeAccName, producerName, name, "CollectionTime", "1m");
            Accumulators.createAccumulator(totalCollectionTimeAccName, producerName, name, "CollectionTime", "default");
        }
        Accumulators.createAccumulatorsSet("GC 1 minute", accumulators);
    }

    public static void createGlobalRequestProcessorAccumulators(List<String> beanNames) {
        ArrayList<String> accumulators = new ArrayList<String>();
        String producerName = "GlobalRequestProcessor";
        String oneMinuteInterval = "1m";
        for (String name : beanNames) {
            String requestCountAccName = String.format("%s request count 1m", name);
            String bytesSentAccName = String.format("%s bytes sent 1m", name);
            String bytesReceivedAccName = String.format("%s bytes received 1m", name);
            String processingTimeAccName = String.format("%s processing time 1m", name);
            String errorCountAccName = String.format("%s error count 1m", name);
            accumulators.addAll(Arrays.asList(requestCountAccName, bytesSentAccName, bytesReceivedAccName, processingTimeAccName, errorCountAccName));
            Accumulators.createAccumulator(requestCountAccName, producerName, name, "RequestCount", oneMinuteInterval);
            Accumulators.createAccumulator(bytesSentAccName, producerName, name, "BytesSent", oneMinuteInterval);
            Accumulators.createAccumulator(bytesReceivedAccName, producerName, name, "BytesReceived", oneMinuteInterval);
            Accumulators.createAccumulator(processingTimeAccName, producerName, name, "ProcessingTime", oneMinuteInterval);
            Accumulators.createAccumulator(errorCountAccName, producerName, name, "ErrorCount", oneMinuteInterval);
        }
        Accumulators.createAccumulatorsSet("Tomcat 1 minute", accumulators);
    }

    public static void setupCPUAccumulators() {
        Accumulators.createAccumulator("CPU Time 1m", "OS", "OS", "CPU Time", "1m", TimeUnit.SECONDS);
        Accumulators.createAccumulator("CPU Time 5m", "OS", "OS", "CPU Time", DEFAULT_INTERVAL, TimeUnit.SECONDS);
        Accumulators.createAccumulator("CPU Time 1h", "OS", "OS", "CPU Time", "1h", TimeUnit.SECONDS);
    }

    private static void createAccumulatorsSet(String name, List<String> accumulators) {
        AccumulatorSetConfig[] accumulatorSets = MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig().getAccumulatorSets();
        if (accumulatorSets == null) {
            accumulatorSets = new AccumulatorSetConfig[]{};
        }
        ArrayList<AccumulatorSetConfig> setConfig = new ArrayList<AccumulatorSetConfig>(Arrays.asList(accumulatorSets));
        AccumulatorSetConfig gcSet = new AccumulatorSetConfig();
        gcSet.setName(name);
        gcSet.setMode(AccumulatorSetMode.MULTIPLE);
        String[] accNames = new String[accumulators.size()];
        gcSet.setAccumulatorNames(accumulators.toArray(accNames));
        setConfig.add(gcSet);
        AccumulatorSetConfig[] accSets = new AccumulatorSetConfig[setConfig.size()];
        MoskitoConfigurationHolder.getConfiguration().getAccumulatorsConfig().setAccumulatorSets(setConfig.toArray(accSets));
    }
}

