/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import java.util.regex.Pattern;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.util.StringUtils;

public class AutoAccumulatorDefinition
extends AccumulatorDefinition {
    private String namePattern;
    private String producerNamePattern;
    private Pattern pattern;

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public String getProducerNamePattern() {
        return this.producerNamePattern;
    }

    public void setProducerNamePattern(String producerNamePattern) {
        this.producerNamePattern = producerNamePattern;
        this.pattern = Pattern.compile(producerNamePattern);
    }

    public AccumulatorDefinition toAccumulatorDefinition(String producerId) {
        AccumulatorDefinition ret = new AccumulatorDefinition();
        ret.setProducerName(producerId);
        ret.setName(this.replaceName(producerId));
        ret.setStatName(this.getStatName());
        ret.setValueName(this.getValueName());
        ret.setIntervalName(this.getIntervalName());
        ret.setTimeUnit(this.getTimeUnit());
        return ret;
    }

    private String replaceName(String producerId) {
        String name = this.namePattern;
        name = StringUtils.replace((String)name, (String)"$PRODUCERID", (String)producerId);
        name = StringUtils.replace((String)name, (String)"$PRODUCERNAME", (String)producerId);
        return name;
    }

    public boolean matches(String producerId) {
        return this.pattern.matcher(producerId).matches();
    }
}

