/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.blueprint;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.blueprint.BlueprintCallExecutor;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;

public class BlueprintProducer
implements IStatsProducer {
    private String producerId;
    private String category;
    private String subsystem;
    private ActionStats stats;
    private List<IStats> statsList;

    public BlueprintProducer(String aProducerId, String aCategory, String aSubsystem) {
        this.producerId = aProducerId;
        this.category = aCategory;
        this.subsystem = aSubsystem;
        this.stats = new ActionStats("execute", this.getMonitoringIntervals());
        this.statsList = new CopyOnWriteArrayList<IStats>();
        this.statsList.add(this.stats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
    }

    public Object execute(BlueprintCallExecutor executor, Object ... parameters) throws Exception {
        CurrentlyTracedCall currentlyTracedCall;
        this.stats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aTracedCall = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall2 = currentlyTracedCall = aTracedCall.callTraced() ? (CurrentlyTracedCall)aTracedCall : null;
        if (currentlyTracedCall != null) {
            currentElement = currentlyTracedCall.startStep(this.getProducerId() + '.' + "execute", this, "execute");
        }
        try {
            Object object = executor.execute(parameters);
            return object;
        }
        catch (Exception e) {
            this.stats.notifyError(e);
            throw e;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.stats.addExecutionTime(duration);
            this.stats.notifyRequestFinished();
            if (currentElement != null) {
                currentElement.setDuration(duration);
            }
            if (currentlyTracedCall != null) {
                currentlyTracedCall.endStep();
            }
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getSubsystem() {
        return this.subsystem;
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }
}

