/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.calltrace;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.journey.JourneyConfig;
import net.anotheria.moskito.core.producers.IStatsProducer;

public class CurrentlyTracedCall
implements TracedCall,
Serializable {
    private static final long serialVersionUID = 3099062979275211864L;
    private String name;
    private TraceStep root = new TraceStep("");
    private TraceStep current;
    private long created;
    private long createdNanos;
    private long endedNanos;
    private Map<String, String> tags;
    private transient JourneyConfig journeyConfig = MoskitoConfigurationHolder.getConfiguration().getJourneyConfig();

    public CurrentlyTracedCall(String aName) {
        this.name = aName;
        this.current = this.root;
        this.created = System.currentTimeMillis();
        this.createdNanos = System.nanoTime();
    }

    @Override
    public boolean callTraced() {
        return true;
    }

    public String toString() {
        return "CurrentlyTracedCall: " + this.name;
    }

    public TraceStep startStep(String call, IStatsProducer producer, String methodName) {
        TraceStep last = this.current;
        this.current = new TraceStep(call, producer, methodName);
        if (last != null) {
            last.addChild(this.current);
        }
        return this.current;
    }

    @Deprecated
    public TraceStep startStep(String call) {
        return this.startStep(call, null, null);
    }

    public void endStep() {
        this.current = this.current.getParent();
    }

    public String getTrace() {
        return this.root.generateTrace();
    }

    public String getName() {
        return this.name;
    }

    public long getCreated() {
        return this.created;
    }

    public TraceStep getRootStep() {
        return this.root;
    }

    public TraceStep getFirstStep() {
        return this.root.getChildren().get(0);
    }

    public TraceStep getLastStep() {
        return this.root.getLastStep();
    }

    public TraceStep getCurrentStep() {
        return this.current;
    }

    public JourneyConfig getJourneyConfig() {
        return this.journeyConfig;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setEnded() {
        this.endedNanos = System.nanoTime();
    }

    public long getDurationNanos() {
        return this.endedNanos - this.createdNanos;
    }

    public int getNumberOfSteps() {
        int result = 0;
        LinkedList<TraceStep> queue = new LinkedList<TraceStep>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            TraceStep currentTraceStep = (TraceStep)queue.poll();
            ++result;
            List<TraceStep> children = currentTraceStep.getChildren();
            if (children.isEmpty()) continue;
            queue.addAll(children);
        }
        return result;
    }

    public void dumpOut() {
        System.out.println(this.toString());
        TraceStep root = this.getRootStep();
        this.dumpOut(root, 1);
    }

    private void dumpOut(TraceStep step, int ident) {
        StringBuilder prfx = new StringBuilder();
        for (int i = 0; i < ident; ++i) {
            prfx.append(' ');
        }
        String prefix = prfx.toString();
        System.out.println(prefix + " " + step.toString());
        for (TraceStep child : step.getChildren()) {
            this.dumpOut(child, ident + 1);
        }
    }
}

