/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.calltrace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.producers.IStatsProducer;

public class TraceStep
implements Serializable {
    private static final long serialVersionUID = 5125788088153070555L;
    private String call;
    private List<TraceStep> children;
    private TraceStep parent;
    private long duration;
    private boolean aborted;
    private transient IStatsProducer producer;
    private String methodName;

    public TraceStep(String aCall) {
        this(aCall, null, null);
    }

    public TraceStep(String aCall, IStatsProducer aProducer, String aMethodName) {
        this.call = aCall;
        this.children = new ArrayList<TraceStep>();
        this.producer = aProducer;
        this.methodName = aMethodName;
    }

    public String getCall() {
        return this.call;
    }

    public List<TraceStep> getChildren() {
        return this.children;
    }

    public void setParent(TraceStep step) {
        this.parent = step;
    }

    public TraceStep getParent() {
        return this.parent;
    }

    public TraceStep getLastStep() {
        TraceStep result = this;
        while (result.children != null && result.children.size() != 0) {
            result = result.children.get(result.children.size() - 1);
        }
        return result;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getCall()).append(" D: ").append(this.getDuration()).append(" ns");
        if (this.isAborted()) {
            ret.append(" aborted.");
        } else {
            ret.append('.');
        }
        return ret.toString();
    }

    public void addChild(TraceStep p) {
        this.children.add(p);
        p.setParent(this);
    }

    public String generateTrace() {
        return this.internalGenerateTrace().toString();
    }

    private StringBuilder internalGenerateTrace() {
        StringBuilder b = new StringBuilder(this.call);
        if (this.children.size() > 0) {
            b.append('[');
            for (int i = 0; i < this.children.size(); ++i) {
                b.append((CharSequence)this.children.get(i).internalGenerateTrace());
                if (i >= this.children.size() - 1) continue;
                b.append(", ");
            }
            b.append(']');
        }
        return b;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void setAborted() {
        this.aborted = true;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getNetDuration() {
        long ret = this.duration;
        for (TraceStep s : this.children) {
            ret -= s.getDuration();
        }
        return ret;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void appendToCall(String s) {
        this.call = this.call + s;
    }

    public IStatsProducer getProducer() {
        return this.producer;
    }

    public String toJSON() {
        StringBuilder ret = new StringBuilder();
        ret.append("{");
        ret.append(this.quote("call")).append(":").append(this.quote(this.call)).append(',');
        if (this.producer != null) {
            ret.append(this.quote("producer")).append(":").append(this.quote(this.producer.getProducerId())).append(',');
            ret.append(this.quote("category")).append(":").append(this.quote(this.producer.getCategory())).append(',');
            ret.append(this.quote("subsystem")).append(":").append(this.quote(this.producer.getSubsystem())).append(',');
        }
        ret.append(this.quote("duration")).append(": ").append(this.duration).append(',');
        ret.append(this.quote("netDuration")).append(": ").append(this.getNetDuration()).append(',');
        ret.append(this.quote("children")).append(": ").append("[");
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(this.getChildren().get(i).toJSON());
        }
        ret.append("]");
        ret.append("}");
        return ret.toString();
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    public String getMethodName() {
        return this.methodName;
    }
}

