/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.config.KillSwitchConfiguration;
import net.anotheria.moskito.core.config.accumulators.AccumulatorsConfig;
import net.anotheria.moskito.core.config.dashboards.DashboardsConfig;
import net.anotheria.moskito.core.config.errorhandling.ErrorHandlingConfig;
import net.anotheria.moskito.core.config.filter.FilterConfig;
import net.anotheria.moskito.core.config.gauges.GaugesConfig;
import net.anotheria.moskito.core.config.journey.JourneyConfig;
import net.anotheria.moskito.core.config.plugins.PluginsConfig;
import net.anotheria.moskito.core.config.producers.BuiltinProducersConfig;
import net.anotheria.moskito.core.config.producers.MBeanProducerConfig;
import net.anotheria.moskito.core.config.producers.TomcatRequestProcessorProducerConfig;
import net.anotheria.moskito.core.config.tagging.TaggingConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdsAlertsConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdsConfig;
import net.anotheria.moskito.core.config.tracing.TracingConfiguration;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import net.anotheria.moskito.core.util.AfterStartTasks;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;

@ConfigureMe(name="moskito")
public class MoskitoConfiguration
implements Serializable {
    private static final long serialVersionUID = 6636333765192447227L;
    @Configure
    private String applicationName = "";
    @Configure
    private String[] intervals = new String[]{"1m", "5m", "15m", "1h", "12h", "1d", "snapshot"};
    @Configure
    @SerializedName(value="@killSwitch")
    private KillSwitchConfiguration killSwitch = new KillSwitchConfiguration();
    @DontConfigure
    private volatile transient Interval[] configuredIntervals;
    @Configure
    @SerializedName(value="@thresholdsAlertsConfig")
    private ThresholdsAlertsConfig thresholdsAlertsConfig = new ThresholdsAlertsConfig();
    @Configure
    @SerializedName(value="@thresholdsConfig")
    private ThresholdsConfig thresholdsConfig = new ThresholdsConfig();
    @Configure
    @SerializedName(value="@gaugesConfig")
    private GaugesConfig gaugesConfig = new GaugesConfig();
    @Configure
    @SerializedName(value="@dashboardsConfig")
    private DashboardsConfig dashboardsConfig = new DashboardsConfig();
    @Configure
    @SerializedName(value="@accumulatorsConfig")
    private AccumulatorsConfig accumulatorsConfig = new AccumulatorsConfig();
    @Configure
    @SerializedName(value="@pluginsConfig")
    private PluginsConfig pluginsConfig = new PluginsConfig();
    @Configure
    @SerializedName(value="@mbeanProducersConfig")
    private MBeanProducerConfig mbeanProducersConfig = new MBeanProducerConfig();
    @Configure
    @SerializedName(value="@builtinProducersConfig")
    private BuiltinProducersConfig builtinProducersConfig = new BuiltinProducersConfig();
    @Configure
    @SerializedName(value="@tomcatRequestProcessorProducerConfig")
    private TomcatRequestProcessorProducerConfig tomcatRequestProcessorProducerConfig = new TomcatRequestProcessorProducerConfig();
    @Configure
    @SerializedName(value="@tracingConfig")
    private TracingConfiguration tracingConfig = new TracingConfiguration();
    @Configure
    @SerializedName(value="@journeyConfig")
    private JourneyConfig journeyConfig = new JourneyConfig();
    @Configure
    @SerializedName(value="@errorHandlingConfig")
    private ErrorHandlingConfig errorHandlingConfig = new ErrorHandlingConfig();
    @Configure
    @SerializedName(value="@filterConfig")
    private FilterConfig filterConfig = new FilterConfig();
    @Configure
    @SerializedName(value="@taggingConfig")
    private TaggingConfig taggingConfig = new TaggingConfig();

    public ThresholdsAlertsConfig getThresholdsAlertsConfig() {
        return this.thresholdsAlertsConfig;
    }

    public void setThresholdsAlertsConfig(ThresholdsAlertsConfig thresholdsAlertsConfig) {
        this.thresholdsAlertsConfig = thresholdsAlertsConfig;
    }

    public ThresholdsConfig getThresholdsConfig() {
        return this.thresholdsConfig;
    }

    public void setThresholdsConfig(ThresholdsConfig thresholds) {
        this.thresholdsConfig = thresholds;
    }

    public String toString() {
        return "thresholdsAlertsConfig: " + this.thresholdsAlertsConfig + ", thresholds: " + this.thresholdsConfig + ", accumulators:" + this.accumulatorsConfig + ", gauges: " + this.gaugesConfig + ", dashboards: " + this.dashboardsConfig + ", errorHandling: " + this.errorHandlingConfig;
    }

    public AccumulatorsConfig getAccumulatorsConfig() {
        return this.accumulatorsConfig;
    }

    public void setAccumulatorsConfig(AccumulatorsConfig accumulatorsConfig) {
        this.accumulatorsConfig = accumulatorsConfig;
    }

    public PluginsConfig getPluginsConfig() {
        return this.pluginsConfig;
    }

    public void setPluginsConfig(PluginsConfig pluginsConfig) {
        this.pluginsConfig = pluginsConfig;
    }

    public MBeanProducerConfig getMbeanProducersConfig() {
        return this.mbeanProducersConfig;
    }

    public void setMbeanProducersConfig(MBeanProducerConfig mbeanProducersConfig) {
        this.mbeanProducersConfig = mbeanProducersConfig;
    }

    public BuiltinProducersConfig getBuiltinProducersConfig() {
        return this.builtinProducersConfig;
    }

    public void setBuiltinProducersConfig(BuiltinProducersConfig builtinProducersConfig) {
        this.builtinProducersConfig = builtinProducersConfig;
    }

    public TomcatRequestProcessorProducerConfig getTomcatRequestProcessorProducerConfig() {
        return this.tomcatRequestProcessorProducerConfig;
    }

    public void setTomcatRequestProcessorProducerConfig(TomcatRequestProcessorProducerConfig tomcatRequestProcessorProducerConfig) {
        this.tomcatRequestProcessorProducerConfig = tomcatRequestProcessorProducerConfig;
    }

    public GaugesConfig getGaugesConfig() {
        return this.gaugesConfig;
    }

    public void setGaugesConfig(GaugesConfig gaugesConfig) {
        this.gaugesConfig = gaugesConfig;
    }

    public DashboardsConfig getDashboardsConfig() {
        return this.dashboardsConfig;
    }

    public void setDashboardsConfig(DashboardsConfig dashboardsConfig) {
        this.dashboardsConfig = dashboardsConfig;
    }

    public TracingConfiguration getTracingConfig() {
        return this.tracingConfig;
    }

    public void setTracingConfig(TracingConfiguration tracingConfig) {
        this.tracingConfig = tracingConfig;
    }

    public JourneyConfig getJourneyConfig() {
        return this.journeyConfig;
    }

    public void setJourneyConfig(JourneyConfig journeyConfig) {
        this.journeyConfig = journeyConfig;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public ErrorHandlingConfig getErrorHandlingConfig() {
        return this.errorHandlingConfig;
    }

    public void setErrorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
        this.errorHandlingConfig = errorHandlingConfig;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public TaggingConfig getTaggingConfig() {
        return this.taggingConfig;
    }

    public void setTaggingConfig(TaggingConfig taggingConfig) {
        this.taggingConfig = taggingConfig;
    }

    public String[] getIntervals() {
        return this.intervals;
    }

    public void setIntervals(String[] intervals) {
        this.intervals = intervals;
    }

    @AfterConfiguration
    public void createIntervalsAfterConfiguration() {
        this.createIntervals();
        AfterStartTasks.submitTask(new Runnable(){

            @Override
            public void run() {
                if (MoskitoConfiguration.this.errorHandlingConfig != null) {
                    MoskitoConfiguration.this.errorHandlingConfig.afterConfiguration();
                }
            }
        });
    }

    private void createIntervals() {
        if (this.intervals == null || this.intervals.length == 0) {
            throw new IllegalStateException("Can't run moskito without intervals at all");
        }
        String[] toConfigure = this.intervals;
        Interval[] newConfiguredIntervals = new Interval[toConfigure.length];
        for (int i = 0; i < toConfigure.length; ++i) {
            Interval newInterval;
            newConfiguredIntervals[i] = newInterval = IntervalRegistry.getInstance().getInterval(toConfigure[i]);
        }
        this.configuredIntervals = newConfiguredIntervals;
    }

    public Interval[] getConfiguredIntervals() {
        if (this.configuredIntervals == null) {
            this.createIntervals();
        }
        return (Interval[])this.configuredIntervals.clone();
    }

    public List<String> getConfiguredIntervalNames() {
        if (this.intervals == null || this.intervals.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.intervals);
    }

    public KillSwitchConfiguration getKillSwitch() {
        return this.killSwitch;
    }

    public void setKillSwitch(KillSwitchConfiguration killSwitch) {
        this.killSwitch = killSwitch;
    }
}

