/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.dashboards;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.anotheria.moskito.core.config.dashboards.ChartConfig;
import net.anotheria.moskito.core.config.dashboards.ChartPattern;
import net.anotheria.moskito.core.config.dashboards.DashboardWidget;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe
@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"}, justification="This is the way configureme works, it provides beans for access")
public class DashboardConfig
implements Serializable {
    private static final long serialVersionUID = 5472953727159931087L;
    private static final Logger log = LoggerFactory.getLogger(DashboardConfig.class);
    @Configure
    private String name;
    private int refresh = 60;
    @Configure
    private ChartConfig[] charts;
    @Configure
    private ChartPattern[] chartPatterns;
    @Configure
    private String[] thresholds;
    @Configure
    private String[] gauges;
    @Configure
    private String[] producers;
    @Configure
    private String[] producerNamePatterns;
    private Pattern[] patterns;
    @Configure
    private String[] widgets = new String[]{DashboardWidget.THRESHOLDS.getName(), DashboardWidget.GAUGES.getName(), DashboardWidget.CHARTS.getName(), DashboardWidget.PRODUCERS.getName()};

    public String toString() {
        StringBuilder sb = new StringBuilder("DashboardConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", refresh=").append(this.refresh);
        sb.append(", charts=").append(Arrays.toString(this.charts));
        sb.append(", chartPatterns=").append(Arrays.toString(this.chartPatterns));
        sb.append(", thresholds=").append(Arrays.toString(this.thresholds));
        sb.append(", gauges=").append(Arrays.toString(this.gauges));
        sb.append(", producers=").append(Arrays.toString(this.producers));
        sb.append(", producerNamePatterns=").append(Arrays.toString(this.producerNamePatterns));
        sb.append(", widgets=").append(Arrays.toString(this.widgets));
        sb.append('}');
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public void setRefresh(int refresh) {
        this.refresh = refresh;
    }

    public String[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(String[] thresholds) {
        this.thresholds = thresholds;
    }

    public ChartConfig[] getCharts() {
        return this.charts;
    }

    public void setCharts(ChartConfig[] charts) {
        this.charts = charts;
    }

    public ChartPattern[] getChartPatterns() {
        return this.chartPatterns;
    }

    public void setChartPatterns(ChartPattern[] chartPatterns) {
        this.chartPatterns = chartPatterns;
        if (chartPatterns != null && chartPatterns.length > 0) {
            for (ChartPattern chartPattern : chartPatterns) {
                LinkedList<Pattern> patterns = new LinkedList<Pattern>();
                for (String accumulatorPattern : chartPattern.getAccumulatorPatterns()) {
                    try {
                        patterns.add(Pattern.compile(accumulatorPattern));
                    }
                    catch (PatternSyntaxException e) {
                        log.warn("Couldn't compile pattern: \"" + accumulatorPattern + "\"", (Throwable)e);
                    }
                }
                chartPattern.setPatterns(patterns.toArray(new Pattern[patterns.size()]));
            }
        }
    }

    public String[] getGauges() {
        return this.gauges;
    }

    public void setGauges(String[] gauges) {
        this.gauges = gauges;
    }

    public String[] getProducers() {
        return this.producers;
    }

    public void setProducers(String[] producers) {
        this.producers = producers;
    }

    public String[] getProducerNamePatterns() {
        return this.producerNamePatterns;
    }

    public void setProducerNamePatterns(String[] producerNamePatterns) {
        this.producerNamePatterns = producerNamePatterns;
        if (producerNamePatterns != null && producerNamePatterns.length > 0) {
            LinkedList<Pattern> patterns = new LinkedList<Pattern>();
            for (String producerNamePattern : this.getProducerNamePatterns()) {
                try {
                    patterns.add(Pattern.compile(producerNamePattern));
                }
                catch (PatternSyntaxException e) {
                    log.warn("Couldn't compile pattern: \"" + producerNamePattern + "\"", (Throwable)e);
                }
            }
            this.setPatterns(patterns.toArray(new Pattern[patterns.size()]));
        }
    }

    public Pattern[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Pattern[] patterns) {
        this.patterns = patterns;
    }

    public String[] getWidgets() {
        return this.widgets;
    }

    public void setWidgets(String[] widgets) {
        this.widgets = widgets;
    }

    public boolean containsGauge(String gaugeName) {
        return this.listContainsElement(this.gauges, gaugeName);
    }

    public boolean containsChart(String chartName) {
        if (this.charts == null || this.charts.length == 0) {
            return false;
        }
        for (ChartConfig cc : this.charts) {
            if (cc.getCaption() == null || !cc.getCaption().equals(chartName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsThreshold(String thresholdName) {
        return this.listContainsElement(this.thresholds, thresholdName);
    }

    private boolean listContainsElement(String[] list, String name) {
        if (list == null || list.length == 0) {
            return false;
        }
        for (String e : list) {
            if (!e.equals(name)) continue;
            return true;
        }
        return false;
    }
}

