/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.producers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import net.anotheria.moskito.core.config.producers.MBeanProducerDomainConfig;
import org.apache.commons.lang.ArrayUtils;
import org.configureme.annotations.Configure;

public class MBeanProducerConfig
implements Serializable {
    private static final long serialVersionUID = 283692361117118195L;
    @Configure
    private boolean registerAutomatically = false;
    @Configure
    private boolean updateAutomatically = true;
    @Configure
    private long delayBeforeFirstUpdate = 15000L;
    @Configure
    private MBeanProducerDomainConfig[] domains;

    public long getDelayBeforeFirstUpdate() {
        return this.delayBeforeFirstUpdate;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public MBeanProducerDomainConfig[] getDomains() {
        return this.domains;
    }

    public boolean isMBeanRequired(String domainName, String className) {
        if (this.domains == null || this.domains.length == 0) {
            return true;
        }
        for (MBeanProducerDomainConfig domainConfig : this.domains) {
            if (!domainConfig.getName().equalsIgnoreCase(domainName)) continue;
            return ArrayUtils.contains((Object[])domainConfig.getClasses(), (Object)className);
        }
        return false;
    }

    public boolean isRegisterAutomatically() {
        return this.registerAutomatically;
    }

    public boolean isUpdateAutomatically() {
        return this.updateAutomatically;
    }

    public void setDelayBeforeFirstUpdate(long milliseconds) {
        this.delayBeforeFirstUpdate = milliseconds;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setDomains(MBeanProducerDomainConfig[] domains) {
        this.domains = domains;
    }

    public void setRegisterAutomatically(boolean flag) {
        this.registerAutomatically = flag;
    }

    public void setUpdateAutomatically(boolean flag) {
        this.updateAutomatically = flag;
    }

    public String toString() {
        return "MBeanProducerConfig{registerAutomatically=" + this.registerAutomatically + ", updateAutomatically=" + this.updateAutomatically + ", delayBeforeFirstUpdate=" + this.delayBeforeFirstUpdate + ", domains=" + Arrays.toString(this.domains) + '}';
    }
}

