/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.tagging;

public enum CustomTagSource {
    NONE(""),
    HEADER("header"),
    REQUEST("request"),
    SESSION("session"),
    PARAMETER("parameter");

    public static final CustomTagSource[] SOURCES;
    private String name;

    private CustomTagSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CustomTagSource findTagSourceByName(String name) {
        for (CustomTagSource source : CustomTagSource.values()) {
            if (!source.getName().equals(name)) continue;
            return source;
        }
        return NONE;
    }

    public String toString() {
        return "CustomTagSource{name='" + this.name + '\'' + '}';
    }

    static {
        SOURCES = new CustomTagSource[]{HEADER, REQUEST, SESSION, PARAMETER};
    }
}

