/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.tag.TagRepository;
import net.anotheria.moskito.core.tag.TagType;
import net.anotheria.util.StringUtils;

public class MoSKitoContext {
    private static final AtomicLong instanceCounter = new AtomicLong();
    private static final InheritableThreadLocal<MoSKitoContext> currentContext = new InheritableThreadLocal<MoSKitoContext>(){

        @Override
        protected MoSKitoContext childValue(MoSKitoContext parentValue) {
            MoSKitoContext child = new MoSKitoContext();
            child.reset();
            child.tags.putAll(MoSKitoContext.getTags());
            return child;
        }

        @Override
        protected MoSKitoContext initialValue() {
            return new MoSKitoContext();
        }
    };
    private HashMap<String, String> tags = new HashMap();
    private HashSet<Integer> seenErrors = new HashSet();
    private volatile IStatsProducer lastProducer;
    private long instanceNumber;
    private AtomicBoolean errorOccured = new AtomicBoolean(false);
    private boolean tracerFired;

    public MoSKitoContext() {
        this.instanceNumber = instanceCounter.incrementAndGet();
    }

    public static MoSKitoContext get() {
        return (MoSKitoContext)currentContext.get();
    }

    public static void addTag(String tagName, String tagValue, TagType type, String source) {
        if (StringUtils.isEmpty((String)tagName) || StringUtils.isEmpty((String)tagValue)) {
            return;
        }
        TagRepository.INSTANCE.addTag(tagName, tagValue, type, source);
        MoSKitoContext.get().tags.put(tagName, tagValue);
    }

    public long getInstanceNumber() {
        return this.instanceNumber;
    }

    public static Map<String, String> getTags() {
        return (Map)MoSKitoContext.get().tags.clone();
    }

    public boolean markErrorAndReturnIfErrorAlreadyHappenedBefore() {
        return this.errorOccured.getAndSet(true);
    }

    public void reset() {
        this.tags = new HashMap();
        this.errorOccured = new AtomicBoolean(false);
        this.seenErrors = new HashSet();
        this.tracerFired = false;
    }

    public static void cleanup() {
        MoSKitoContext.get().reset();
        currentContext.remove();
    }

    public boolean seenErrorAlready(Throwable throwable) {
        Integer key = MoSKitoContext.getHashKey(throwable);
        if (this.seenErrors.contains(key)) {
            return true;
        }
        this.seenErrors.add(key);
        return false;
    }

    public boolean hasTracerFired() {
        return this.tracerFired;
    }

    public void setTracerFired() {
        this.tracerFired = true;
    }

    static Integer getHashKey(Throwable t) {
        return t.hashCode();
    }

    public IStatsProducer getLastProducer() {
        return this.lastProducer;
    }

    public void setLastProducer(IStatsProducer lastProducer) {
        this.lastProducer = lastProducer;
    }
}

