/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.counter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public abstract class GenericCounterStats
extends AbstractStats {
    private HashMap<String, StatValue> values;
    private final List<String> valueNames;

    protected GenericCounterStats(String name, Interval[] intervals, List<String> counters) {
        super(name);
        if (counters != null && !counters.isEmpty()) {
            this.values = new HashMap(counters.size());
            for (String counter : counters) {
                StatValue statValue = StatValueFactory.createStatValue(0L, counter, intervals);
                this.values.put(counter, statValue);
                super.addStatValues(statValue);
            }
        } else {
            throw new IllegalArgumentException("Illegal counters=" + counters);
        }
        this.valueNames = Collections.unmodifiableList(counters);
    }

    protected GenericCounterStats(String name, Interval[] intervals, String ... counters) {
        this(name, intervals, Arrays.asList(counters));
    }

    protected GenericCounterStats(String name, List<String> counters) {
        this(name, Constants.getDefaultIntervals(), counters);
    }

    protected GenericCounterStats(String name, String ... counters) {
        this(name, Constants.getDefaultIntervals(), counters);
    }

    public void inc(String counterName) {
        this.values.get(counterName).increase();
    }

    public void dec(String counterName) {
        this.values.get(counterName).decrease();
    }

    public void incBy(String counterName, long value) {
        this.values.get(counterName).increaseByLong(value);
    }

    public void decBy(String counterName, long value) {
        this.values.get(counterName).decreaseByLong(value);
    }

    public long get(String counterName, String intervalName) {
        return this.values.get(counterName).getValueAsLong(intervalName);
    }

    public void set(String counterName, int value) {
        this.values.get(counterName).setValueAsInt(value);
    }

    @Override
    public String toStatsString(String aIntervalName, TimeUnit unit) {
        StringBuilder s = new StringBuilder();
        s.append(this.getName()).append(' ');
        for (String name : this.valueNames) {
            StatValue statValue = this.values.get(name);
            long longValue = statValue.getValueAsLong(aIntervalName);
            s.append(name).append(": ").append(longValue);
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return this.getName() + ' ' + this.values.values();
    }

    public abstract String describeForWebUI();

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        valueName = valueName.toLowerCase();
        return String.valueOf(this.get(valueName, intervalName));
    }

    @Override
    public List<String> getAvailableValueNames() {
        return this.valueNames;
    }

    @Deprecated
    public Set<String> getPossibleNames() {
        return new LinkedHashSet<String>(this.getAvailableValueNames());
    }
}

