/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators;

import java.io.Serializable;
import net.anotheria.moskito.core.decorators.IDecoratorFactory;
import net.anotheria.moskito.core.producers.ICustomDecoratorStats;
import net.anotheria.moskito.core.producers.IStats;

public class DecoratorName
implements Serializable {
    private static final long serialVersionUID = -7449768549625929124L;
    private String statsClass;
    private String decoratorId;
    private IDecoratorFactory factory;
    private boolean customDecorator = false;

    public DecoratorName(IStats stats) {
        this.statsClass = stats.getClass().getCanonicalName();
        if (stats instanceof ICustomDecoratorStats) {
            ICustomDecoratorStats customDecoratorStats = (ICustomDecoratorStats)stats;
            this.customDecorator = true;
            this.decoratorId = customDecoratorStats.getDecoratorId();
            this.factory = customDecoratorStats.getDecoratorFactory();
        }
    }

    public IDecoratorFactory getFactory() {
        return this.factory;
    }

    public String getDecoratorId() {
        return this.decoratorId;
    }

    public String getStatsClass() {
        return this.statsClass;
    }

    public boolean isCustomDecorator() {
        return this.customDecorator;
    }
}

