/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.counter;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.counter.GenericCounterStats;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.stats.TimeUnit;

public abstract class GenericCounterDecorator
extends AbstractDecorator<GenericCounterStats> {
    private final List<String> valueNames;

    public GenericCounterDecorator(GenericCounterStats patternObject, String[] captions, String[] shortExplanations, String[] explanations) {
        super(patternObject.describeForWebUI(), captions, shortExplanations, explanations);
        this.valueNames = patternObject.getAvailableValueNames();
    }

    public GenericCounterDecorator(GenericCounterStats patternObject, List<String> captions, List<String> shortExplanations, List<String> explanations) {
        this(patternObject, captions.toArray(new String[captions.size()]), shortExplanations.toArray(new String[shortExplanations.size()]), explanations.toArray(new String[explanations.size()]));
    }

    public GenericCounterDecorator(GenericCounterStats patternObject, String[] shortExplanations, String[] explanations) {
        this(patternObject, patternObject.getAvailableValueNames().toArray(new String[patternObject.getAvailableValueNames().size()]), shortExplanations, explanations);
    }

    public GenericCounterDecorator(GenericCounterStats patternObject, List<String> shortExplanations, List<String> explanations) {
        this(patternObject, patternObject.getAvailableValueNames(), shortExplanations, explanations);
    }

    public GenericCounterDecorator(GenericCounterStats patternObject) {
        this(patternObject, patternObject.getAvailableValueNames(), patternObject.getAvailableValueNames(), patternObject.getAvailableValueNames());
    }

    @Override
    public List<StatValueAO> getValues(GenericCounterStats stats, String interval, TimeUnit unit) {
        ArrayList<StatValueAO> statValues = new ArrayList<StatValueAO>(this.valueNames.size());
        for (int i = 0; i < this.valueNames.size(); ++i) {
            String name = this.valueNames.get(i);
            String caption = this.getCaptions().get(i).getCaption();
            long value = stats.get(name, interval);
            statValues.add(new LongValueAO(caption, value));
        }
        return statValues;
    }
}

