/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.mbean;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.IDecoratorFactory;
import net.anotheria.moskito.core.decorators.mbean.MBeanDecorator;
import net.anotheria.moskito.core.decorators.value.StatCaptionBean;
import net.anotheria.moskito.core.predefined.MBeanStats;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;

public class MBeanDecoratorFactory
implements IDecoratorFactory<MBeanStats> {
    private static final long serialVersionUID = 8571967068028956675L;
    private final Map<String, String> attributesDescriptions = new HashMap<String, String>();

    public MBeanDecoratorFactory(MBeanStats stats) {
        for (TypeAwareStatValue statValue : stats.getAllValues()) {
            String valueName = statValue.getName();
            this.attributesDescriptions.put(valueName, stats.getValueDescriptionByName(valueName));
        }
    }

    @Override
    public IDecorator buildDecorator() {
        LinkedList<StatCaptionBean> captions = new LinkedList<StatCaptionBean>();
        for (Map.Entry<String, String> description : this.attributesDescriptions.entrySet()) {
            String valueName = description.getKey();
            String valueDescription = description.getValue();
            captions.add(new StatCaptionBean(valueName, valueDescription, valueDescription));
        }
        return new MBeanDecorator(captions);
    }
}

