/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.GCStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class GCStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"CollectionCount", "CollectionTime"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Collection count", "Collection time"};
    private static final String[] EXPLANATIONS = new String[]{"Total number of collections that have occurred", "Approximate accumulated collection elapsed time in milliseconds"};

    public GCStatsDecorator() {
        super("GC", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        GCStats stats = (GCStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCollectionCount(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCollectionTime(interval)));
        return ret;
    }
}

