/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.GlobalRequestProcessorStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class GlobalRequestProcessorStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"RequestCount", "MaxTime", "BytesReceived", "BytesSent", "ProcessingTime", "ErrorCount"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Request Count", "Max Time", "Bytes Received", "Bytes Sent", "Processing Time", "Error Count"};
    private static final String[] EXPLANATIONS = new String[]{"Request count on all the request processors running on the Apache Tomcat container", "Max Time on all the request processors running on the Apache Tomcat container", "Bytes received by all the request processors running on the Apache Tomcat container", "Bytes sent by all the request processors running on the Apache Tomcat container", "Processing Time on all the request processors running on the Apache Tomcat container", "Error count on all the request processors running on the Apache Tomcat container collection"};

    public GlobalRequestProcessorStatsDecorator() {
        super("GlobalRequestProcessor", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        GlobalRequestProcessorStats stats = (GlobalRequestProcessorStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getRequestCount(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMaxTime(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getBytesReceived(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getBytesSent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getProcessingTime(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getErrorCount(interval)));
        return ret;
    }
}

