/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.dynamic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;

public class MoskitoInvokationProxy<S extends IStats>
implements InvocationHandler {
    private Class<?>[] supportedInterfaces;
    private Class<?>[] declaredExceptions;
    private Object implementation;
    private IOnDemandCallHandler handler;
    private OnDemandStatsProducer<S> producer;
    private final MoskitoConfiguration configuration;

    public MoskitoInvokationProxy(Object anImplementation, IOnDemandCallHandler aHandler, IOnDemandStatsFactory<S> factory, String producerId, String category, String subsystem, Class<?> ... interfaces) {
        if (interfaces.length == 0) {
            throw new RuntimeException("No interfaces specified!");
        }
        this.configuration = MoskitoConfigurationHolder.getConfiguration();
        this.implementation = anImplementation;
        this.supportedInterfaces = interfaces;
        this.handler = aHandler;
        this.producer = new OnDemandStatsProducer<S>(producerId, category, subsystem, factory);
        this.producer.setTracingSupported(true);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this.producer);
        this.guessExceptions();
    }

    public MoskitoInvokationProxy(Object anImplementation, IOnDemandCallHandler aHandler, IOnDemandStatsFactory factory, Class<?> ... interfaces) {
        this(anImplementation, aHandler, factory, MoskitoInvokationProxy.guessProducerId(anImplementation), null, null, interfaces);
    }

    public MoskitoInvokationProxy(Object anImplementation, IOnDemandCallHandler aHandler, IOnDemandStatsFactory factory, String category, String subsystem, Class<?> ... interfaces) {
        this(anImplementation, aHandler, factory, MoskitoInvokationProxy.guessProducerId(anImplementation), category, subsystem, interfaces);
    }

    private static String guessProducerId(Object implementation) {
        String className = implementation.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private void guessExceptions() {
        ArrayList tmpExceptionList = new ArrayList();
        for (Class<?> c : this.supportedInterfaces) {
            Method[] methods;
            for (Method m : methods = c.getDeclaredMethods()) {
                for (Class<?> exc : m.getExceptionTypes()) {
                    if (tmpExceptionList.contains(exc)) continue;
                    tmpExceptionList.add(exc);
                }
            }
        }
        this.declaredExceptions = new Class[tmpExceptionList.size()];
        tmpExceptionList.toArray(this.declaredExceptions);
    }

    @Override
    public Object invoke(Object aProxy, Method aMethod, Object[] args) throws Throwable {
        Class<?> methodsClass = aMethod.getDeclaringClass();
        for (Class<?> c : this.supportedInterfaces) {
            if (!c.equals(methodsClass)) continue;
            if (this.configuration.getKillSwitch().disableMetricCollection()) {
                return aMethod.invoke(this.implementation, args);
            }
            return this.handler.invoke(this.implementation, args, aMethod, c, this.declaredExceptions, (IStats)this.producer.getDefaultStats(), (IStats)this.producer.getStats(aMethod.getName()), this.producer);
        }
        return aMethod.invoke((Object)this, args);
    }

    public Object createProxy() {
        return this.createProxy(this.implementation.getClass().getClassLoader());
    }

    public Object createProxy(ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, this.supportedInterfaces, (InvocationHandler)this);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public IStatsProducer getProducer() {
        return this.producer;
    }
}

