/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.dynamic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.logging.LoggerUtil;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskito.core.producers.IStats;

public class ProxyUtils {
    private static final ConcurrentMap<String, AtomicInteger> instanceCounters = new ConcurrentHashMap<String, AtomicInteger>();

    private ProxyUtils() {
    }

    public static <T> T createInstance(T impl, String name, String category, String subsystem, IOnDemandCallHandler handler, IOnDemandStatsFactory<? extends IStats> statsFactory, boolean attachLoggers, Class<T> interf, Class<?> ... additionalInterfaces) {
        if (name == null) {
            name = ProxyUtils.extractName(interf);
        }
        Class<?>[] interfacesParameter = ProxyUtils.mergeInterfaces(interf, additionalInterfaces);
        MoskitoInvokationProxy<? extends IStats> proxy = new MoskitoInvokationProxy<IStats>(impl, handler, statsFactory, name + '-' + ProxyUtils.getInstanceCounter(name), category, subsystem, interfacesParameter);
        Object ret = proxy.createProxy();
        if (attachLoggers) {
            LoggerUtil.createSLF4JDefaultAndIntervalStatsLogger(proxy.getProducer());
        }
        return (T)ret;
    }

    static Class<?>[] mergeInterfaces(Class<?> interf, Class<?> ... additionalInterfaces) {
        Class[] interfacesParameter = new Class[additionalInterfaces == null ? 1 : 1 + additionalInterfaces.length];
        interfacesParameter[0] = interf;
        if (additionalInterfaces != null) {
            System.arraycopy(additionalInterfaces, 0, interfacesParameter, 1, additionalInterfaces.length);
        }
        return interfacesParameter;
    }

    public static <T> T createServiceInstance(T impl, String name, String category, String subsystem, boolean attachLoggers, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createInstance(impl, name, category, subsystem, new ServiceStatsCallHandler(), new ServiceStatsFactory(), attachLoggers, interf, additionalInterfaces);
    }

    public static <T> T createServiceInstance(T impl, String name, String category, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, name, category, subsystem, false, interf, additionalInterfaces);
    }

    public static <T> T createServiceInstance(T impl, String category, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, category, subsystem, interf, additionalInterfaces);
    }

    public static <T> T createServiceInstance(T impl, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, "service", subsystem, interf, additionalInterfaces);
    }

    public static <T> T createDAOInstance(T impl, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, "dao", subsystem, interf, additionalInterfaces);
    }

    private static int getInstanceCounter(String name) {
        AtomicInteger counter = (AtomicInteger)instanceCounters.get(name);
        if (counter != null) {
            return counter.incrementAndGet();
        }
        counter = new AtomicInteger(0);
        AtomicInteger old = instanceCounters.putIfAbsent(name, counter);
        if (old != null) {
            counter = old;
        }
        return counter.incrementAndGet();
    }

    private static String extractName(Class<?> clazz) {
        int indexOfDot;
        String name = clazz.getName();
        if (name == null) {
            name = "";
        }
        return (indexOfDot = name.lastIndexOf(46)) == -1 ? name : name.substring(indexOfDot + 1);
    }
}

